package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;


import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.dto.BizMessage;
import com.yeejoin.amos.boot.module.jxiop.api.dto.RiskBizInfoVo;
import com.yeejoin.amos.boot.module.jxiop.api.dto.RiskDynamicDetailsVo;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.Enum.WarningNameEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.*;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.*;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
@EnableScheduling
@Service
@Slf4j
public class HealthStatusIndicatorServiceImpl {

   // @Value("${healthValue_Warn}")
   // Double healthValueWarn;
   // @Value("${healthValue_Risk}")
   // Double healthValueRisk;
   // @Value("${healthValue_Notice}")
   // Double healthValueNotice;

   // @Value("${healthValue_DayCount}")
   // long healthValueDayCount;
   // @Value("${healthValue_HourCount}")
   // long healthValueHourCount;
   // @Value("${healthValue_MinCount}")
   // long healthValueMinCount;

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    IdxBizFanHealthIndexMapper idxBizFanHealthIndexMapper;

    @Autowired
    IdxBizFanWarningRecordMapper idxBizFanWarningRecordMapper;

    @Autowired
    IdxBizPvWarningRecordServiceImpl idxBizPvWarningRecordService;
    @Autowired
    IdxBizFanWarningRecordServiceImpl idxBizFanWarningRecordService;

    /***
     * 每一小时获取一次最大粒度内的指数异常数据
     * 判断一小时内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */



    @Autowired
    IdxBizPvHealthIndexMapper idxBizPvHealthIndexMapper;
    @Autowired
    IdxBizPvWarningRuleSetMapper idxBizPvWarningRuleSetMapper;
    @Autowired
    IdxBizFanWarningRuleSetMapper idxBizFanWarningRuleSetMapper;

    @Autowired
    IdxBizPvWarningRecordMapper idxBizPvWarningRecordMapper;

    @Autowired
    StationBasicMapper stationBasicMapper;

    @Autowired
    EmqKeeper emqKeeper;

    /**
     * 夏造风电分析index_key
     */
    public static final String INDEX_KEY_FAN = "XZFX#FX%s#ZNFX";

    /**
     * 泰和光伏分析 index_key
     */
    public static final String INDEX_KEY_PV = "THFX#FXGF#ZNFX";

    /**
     * 智能分析触发预警系统标识 - 光伏
     */
    public static final String SMART_ANALYSE_PV = "smartAnalysePv";

    /**
     * 智能分析触发预警系统标识 - 风电
     */
    public static final String SMART_ANALYSE_FAN = "smartAnalyseFan";


    /***
     * 每一小时获取一次最大粒度内的指数异常数据
     * 判断一小时内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */

   // @Scheduled(cron = "0 0 */1 * * ?")
    @Async("async")
    public void healthWarningMinuteGF(Calendar calendar,Date time ) {
       // Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY,calendar.get(Calendar.HOUR_OF_DAY)-1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");


        LambdaQueryWrapper<IdxBizPvHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizPvHealthIndex::getAnalysisType,"按时刻");
        wrapper.ne(IdxBizPvHealthIndex::getHealthLevel,"安全");
        wrapper.ge(IdxBizPvHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizPvHealthIndex::getRecDate);
        List<IdxBizPvHealthIndex> healthIndices = idxBizPvHealthIndexMapper.selectList(wrapper);
        List<String> collect = healthIndices.stream().map(IdxBizPvHealthIndex::getAnalysisObjSeq).collect(Collectors.toList());
        if (null == healthIndices ){
            return;
        }
        LambdaQueryWrapper<IdxBizPvWarningRuleSet> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(IdxBizPvWarningRuleSet::getAnalysisType,"按时刻");
        queryWrapper.in(IdxBizPvWarningRuleSet::getAnalysisPointId, collect);
        List<IdxBizPvWarningRuleSet> idxBizPvWarningRules = idxBizPvWarningRuleSetMapper.selectList(queryWrapper);


        Map<String, Map<String, List<IdxBizPvHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizPvHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizPvHealthIndex::getIndexAddress)));
        List<IdxBizPvWarningRecord> idxBizPvWarningRecordList = new ArrayList<>();
        HashMap<String, StationBasic> stationMap = new HashMap<>();
        for (String gateWayId : gateWayMaps.keySet()) {

            LambdaQueryWrapper<StationBasic> basicLambdaQueryWrapper = new LambdaQueryWrapper<>();
            basicLambdaQueryWrapper.eq(StationBasic::getFanGatewayId, gateWayId);
            basicLambdaQueryWrapper.last("limit 1");
            StationBasic stationBasic = stationBasicMapper.selectOne(basicLambdaQueryWrapper);
            stationMap.put(gateWayId, stationBasic);

            Map<String, List<IdxBizPvHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizPvHealthIndex> idxBizPvHealthIndices = healthDataMaps.get(address);
                List<IdxBizPvWarningRuleSet> idxBizPvWarningRuleSets = idxBizPvWarningRules.stream().filter(t -> t.getAnalysisPointId().equals(idxBizPvHealthIndices.get(0).getAnalysisObjSeq())).collect(Collectors.toList());
                if (ObjectUtils.isEmpty(idxBizPvWarningRuleSets) ){
                    continue;
                }
                Double healthValueWarn = 0.0;
                Double healthValueRisk = 0.0;
                Double healthValueNotice = 0.0;

                long healthValueDayCount = 0;
                long healthValueHourCount = 0;
                long healthValueMinCount = 0;


                for (IdxBizPvWarningRuleSet e : idxBizPvWarningRuleSets) {
                    switch (e.getWarningName()){
                        case "警告":
                            healthValueWarn = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueMinCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "危险":
                            healthValueRisk = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueMinCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "注意":
                            healthValueNotice = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueMinCount =Long.parseLong(e.getWarningCycle());
                            break;
                    }

                }

                List<Double> healthIndex = idxBizPvHealthIndices.stream().map(IdxBizPvHealthIndex::getHealthIndex).collect(Collectors.toList());
                Double finalHealthValueRisk = healthValueRisk;
                long riskNum = healthIndex.stream().filter(e -> e <= finalHealthValueRisk).count();
                Double finalHealthValueWarn = healthValueWarn;
                long warnNum = healthIndex.stream().filter(e -> e <= finalHealthValueWarn).count();
                Double finalHealthValueNotice = healthValueNotice;
                long noticeNum = healthIndex.stream().filter(e -> e <= finalHealthValueNotice).count();
                String level = "";
                String content = "";
                String num = "";
                content = healthValueMinCount*10 + "分钟";
                if (noticeNum >= healthValueMinCount ){
                    //     redisUtils.set(gateWayId+"_"+address+"_health_notice_minute","notice");
                    level ="注意";
                    num = ""+healthValueNotice;
                }else if (warnNum >= healthValueMinCount ){
                //    redisUtils.set(gateWayId+"_"+address+"_health_warn_minute","warn");
                    level ="警告";
                    num = ""+healthValueWarn;
                }else if (riskNum >= healthValueMinCount ){
                    //   redisUtils.set(gateWayId+"_"+address+"_health_risk_minute","risk");
                    level ="危险";
                    num = ""+healthValueRisk;
                }
                //库里若已存在该测点预警 不生成重复的 若新生预警等级高于历史 则生成
                LambdaQueryWrapper<IdxBizPvWarningRecord> query = new LambdaQueryWrapper<>();
                query.eq(IdxBizPvWarningRecord::getAnalysisPointId,idxBizPvHealthIndices.get(0).getAnalysisObjSeq());
                query.eq(IdxBizPvWarningRecord::getStatus,0);
                query.orderByDesc(IdxBizPvWarningRecord::getRecDate);
                List<IdxBizPvWarningRecord> idxBizPvWarningRecords = idxBizPvWarningRecordMapper.selectList(query);

                int flag = ObjectUtils.isEmpty(idxBizPvWarningRecords)  || WarningNameEnum.getCode(level) > WarningNameEnum.getCode(idxBizPvWarningRecords.get(0).getWarningName()) ? 0 :1;

                if (!level.equals("") && flag == 0){
                    IdxBizPvWarningRecord idxBizPvWarningRecord = new IdxBizPvWarningRecord();
                    idxBizPvWarningRecord.setKks(idxBizPvHealthIndices.get(0).getKks());
                    idxBizPvWarningRecord.setRecord(idxBizPvHealthIndices.get(0).getRecord());
                    idxBizPvWarningRecord.setArae(idxBizPvHealthIndices.get(0).getArae());
                    idxBizPvWarningRecord.setStation(idxBizPvHealthIndices.get(0).getStation());
                    idxBizPvWarningRecord.setSubarray(idxBizPvHealthIndices.get(0).getSubarray());
                    idxBizPvWarningRecord.setGatewayId(gateWayId);
                    idxBizPvWarningRecord.setIndexAddress(address);
                    idxBizPvWarningRecord.setEquipmentName(idxBizPvHealthIndices.get(0).getEquipmentName());
                    idxBizPvWarningRecord.setAnalysisPointId(idxBizPvHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizPvWarningRecord.setDisposotionState("未处置");
                    idxBizPvWarningRecord.setStatus("0");
                    idxBizPvWarningRecord.setWarningName(level);
                    idxBizPvWarningRecord.setCONTENT(idxBizPvHealthIndices.get(0).getPointName() + "连续"+content+"健康指数<"+num );
                    idxBizPvWarningRecord.setRecDate(time);
                    idxBizPvWarningRecord.setManufacturer(idxBizPvHealthIndices.get(0).getManufacturer());
                    idxBizPvWarningRecord.setPointName(idxBizPvHealthIndices.get(0).getPointName());
                    idxBizPvWarningRecord.setHealthIndexSeq(idxBizPvHealthIndices.get(0).getHealthIndex().toString());
                    idxBizPvWarningRecord.setHealthLevel(idxBizPvHealthIndices.get(0).getHealthLevel());
                    idxBizPvWarningRecordList.add(idxBizPvWarningRecord);

                   // idxBizPvWarningRecordMapper.insert(idxBizPvWarningRecord);
                }
            }
        }
        idxBizPvWarningRecordService.saveBatch(idxBizPvWarningRecordList);
        // 触发风险模型生成预警处置模块的预警记录
        fetchDataPv(idxBizPvWarningRecordList, stationMap);

    }

    /***
     * 每五小时获取一次最大粒度内的指数异常数据
     * 判断五小时内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */

    @Scheduled(cron = "0 0 0/1 * * ?")
    @Async("async")
    public void healthWarningHourGF() {
        Date time = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY,calendar.get(Calendar.HOUR_OF_DAY)-5);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

        LambdaQueryWrapper<IdxBizPvHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizPvHealthIndex::getAnalysisType,"按小时");
        wrapper.ne(IdxBizPvHealthIndex::getHealthLevel,"安全");
        wrapper.ge(IdxBizPvHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizPvHealthIndex::getRecDate);
        List<IdxBizPvHealthIndex> healthIndices = idxBizPvHealthIndexMapper.selectList(wrapper);
        List<String> collect = healthIndices.stream().map(IdxBizPvHealthIndex::getAnalysisObjSeq).collect(Collectors.toList());
        if (null == healthIndices ){
            return;
        }
        LambdaQueryWrapper<IdxBizPvWarningRuleSet> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(IdxBizPvWarningRuleSet::getAnalysisType,"按小时");
        queryWrapper.in(IdxBizPvWarningRuleSet::getAnalysisPointId, collect);
        List<IdxBizPvWarningRuleSet> idxBizPvWarningRules = idxBizPvWarningRuleSetMapper.selectList(queryWrapper);


        Map<String, Map<String, List<IdxBizPvHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizPvHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizPvHealthIndex::getIndexAddress)));
        List<IdxBizPvWarningRecord> idxBizPvWarningRecordList = new ArrayList<>();
        HashMap<String, StationBasic> stationMap = new HashMap<>();
        for (String gateWayId : gateWayMaps.keySet()) {

            LambdaQueryWrapper<StationBasic> basicLambdaQueryWrapper = new LambdaQueryWrapper<>();
            basicLambdaQueryWrapper.eq(StationBasic::getFanGatewayId, gateWayId);
            basicLambdaQueryWrapper.last("limit 1");
            StationBasic stationBasic = stationBasicMapper.selectOne(basicLambdaQueryWrapper);
            stationMap.put(gateWayId, stationBasic);

            Map<String, List<IdxBizPvHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizPvHealthIndex> idxBizPvHealthIndices = healthDataMaps.get(address);
                List<IdxBizPvWarningRuleSet> idxBizPvWarningRuleSets = idxBizPvWarningRules.stream().filter(t -> t.getAnalysisPointId().equals(idxBizPvHealthIndices.get(0).getAnalysisObjSeq())).collect(Collectors.toList());
                if (ObjectUtils.isEmpty(idxBizPvWarningRuleSets) ){
                    continue;
                }

                Double healthValueWarn = 0.0;
                Double healthValueRisk = 0.0;
                Double healthValueNotice = 0.0;

                long healthValueDayCount = 0;
                long healthValueHourCount = 0;
                long healthValueMinCount = 0;


                for (IdxBizPvWarningRuleSet e : idxBizPvWarningRuleSets) {
                    switch (e.getWarningName()){
                        case "警告":
                            healthValueWarn = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueHourCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "危险":
                            healthValueRisk = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueHourCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "注意":
                            healthValueNotice = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueHourCount =Long.parseLong(e.getWarningCycle());
                            break;
                    }

                }

                List<Double> healthIndex = idxBizPvHealthIndices.stream().map(IdxBizPvHealthIndex::getHealthIndex).collect(Collectors.toList());
                Double finalHealthValueRisk = healthValueRisk;
                long riskNum = healthIndex.stream().filter(e -> e <= finalHealthValueRisk).count();
                Double finalHealthValueWarn = healthValueWarn;
                long warnNum = healthIndex.stream().filter(e -> e <= finalHealthValueWarn).count();
                Double finalHealthValueNotice = healthValueNotice;
                long noticeNum = healthIndex.stream().filter(e -> e <= finalHealthValueNotice).count();

                String level = "";
                String content = "";
                String num = "";
                content = healthValueHourCount + "小时";
                if (noticeNum >= healthValueHourCount ){

                    level ="注意";
                    num = ""+healthValueNotice;

                }else if (warnNum >= healthValueHourCount  ){

                    level ="警告";
                    num = ""+healthValueWarn;

                }else if (riskNum >= healthValueHourCount ){

                    level ="危险";
                    num = ""+healthValueRisk;
                }
                //库里若已存在该测点预警 不生成重复的 若新生预警等级高于历史 则生成
                LambdaQueryWrapper<IdxBizPvWarningRecord> query = new LambdaQueryWrapper<>();
                query.eq(IdxBizPvWarningRecord::getAnalysisPointId,idxBizPvHealthIndices.get(0).getAnalysisObjSeq());
                query.eq(IdxBizPvWarningRecord::getStatus,0);
                query.orderByDesc(IdxBizPvWarningRecord::getRecDate);
                List<IdxBizPvWarningRecord> idxBizPvWarningRecords = idxBizPvWarningRecordMapper.selectList(query);

                int flag = ObjectUtils.isEmpty(idxBizPvWarningRecords)  || WarningNameEnum.getCode(level) > WarningNameEnum.getCode(idxBizPvWarningRecords.get(0).getWarningName()) ? 0 :1;

                if (!level.equals("") && flag == 0){
                    IdxBizPvWarningRecord idxBizPvWarningRecord = new IdxBizPvWarningRecord();
                    idxBizPvWarningRecord.setKks(idxBizPvHealthIndices.get(0).getKks());
                    idxBizPvWarningRecord.setRecord(idxBizPvHealthIndices.get(0).getRecord());
                    idxBizPvWarningRecord.setArae(idxBizPvHealthIndices.get(0).getArae());
                    idxBizPvWarningRecord.setStation(idxBizPvHealthIndices.get(0).getStation());
                    idxBizPvWarningRecord.setSubarray(idxBizPvHealthIndices.get(0).getSubarray());
                    idxBizPvWarningRecord.setGatewayId(gateWayId);
                    idxBizPvWarningRecord.setIndexAddress(address);
                    idxBizPvWarningRecord.setEquipmentName(idxBizPvHealthIndices.get(0).getEquipmentName());
                    idxBizPvWarningRecord.setAnalysisPointId(idxBizPvHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizPvWarningRecord.setDisposotionState("未处置");
                    idxBizPvWarningRecord.setStatus("0");
                    idxBizPvWarningRecord.setWarningName(level);
                    idxBizPvWarningRecord.setCONTENT(idxBizPvHealthIndices.get(0).getPointName() + "连续"+content+"健康指数<"+num );
                    idxBizPvWarningRecord.setRecDate(time);
                    idxBizPvWarningRecord.setManufacturer(idxBizPvHealthIndices.get(0).getManufacturer());
                    idxBizPvWarningRecord.setPointName(idxBizPvHealthIndices.get(0).getPointName());
                    idxBizPvWarningRecord.setHealthIndexSeq(idxBizPvHealthIndices.get(0).getHealthIndex().toString());
                    idxBizPvWarningRecord.setHealthLevel(idxBizPvHealthIndices.get(0).getHealthLevel());
                    idxBizPvWarningRecordList.add(idxBizPvWarningRecord);
                    //idxBizPvWarningRecordMapper.insert(idxBizPvWarningRecord);
                }
            }
        }
        idxBizPvWarningRecordService.saveBatch(idxBizPvWarningRecordList);
        // 触发风险模型生成预警处置模块的预警记录
        fetchDataPv(idxBizPvWarningRecordList, stationMap);
    }

    /***
     * 每三天取一次最大粒度内的指数异常数据
     * 判断三天内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */

    @Scheduled(cron = "0 0 0 0/1 * ? ")
    @Async("async")
    public void healthWarningDayGF() {
        Calendar calendar = Calendar.getInstance();
        Date time = new Date();
        calendar.set(Calendar.DAY_OF_MONTH,calendar.get(Calendar.DAY_OF_MONTH)-3);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

        LambdaQueryWrapper<IdxBizPvHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizPvHealthIndex::getAnalysisType,"按天");
        wrapper.ne(IdxBizPvHealthIndex::getHealthLevel,"安全");
        wrapper.ge(IdxBizPvHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizPvHealthIndex::getRecDate);
        List<IdxBizPvHealthIndex> healthIndices = idxBizPvHealthIndexMapper.selectList(wrapper);

        if (null == healthIndices ){
            return;
        }
        List<String> collect = healthIndices.stream().map(IdxBizPvHealthIndex::getAnalysisObjSeq).collect(Collectors.toList());

        LambdaQueryWrapper<IdxBizPvWarningRuleSet> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(IdxBizPvWarningRuleSet::getAnalysisType,"按天");
        queryWrapper.in(IdxBizPvWarningRuleSet::getAnalysisPointId, collect);
        List<IdxBizPvWarningRuleSet> idxBizPvWarningRules = idxBizPvWarningRuleSetMapper.selectList(queryWrapper);
        Map<String, Map<String, List<IdxBizPvHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizPvHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizPvHealthIndex::getIndexAddress)));
        List<IdxBizPvWarningRecord> idxBizPvWarningRecordList = new ArrayList<>();
        HashMap<String, StationBasic> stationMap = new HashMap<>();
        for (String gateWayId : gateWayMaps.keySet()) {

            LambdaQueryWrapper<StationBasic> basicLambdaQueryWrapper = new LambdaQueryWrapper<>();
            basicLambdaQueryWrapper.eq(StationBasic::getFanGatewayId, gateWayId);
            basicLambdaQueryWrapper.last("limit 1");
            StationBasic stationBasic = stationBasicMapper.selectOne(basicLambdaQueryWrapper);
            stationMap.put(gateWayId, stationBasic);

            Map<String, List<IdxBizPvHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizPvHealthIndex> idxBizPvHealthIndices = healthDataMaps.get(address);
                List<IdxBizPvWarningRuleSet> idxBizPvWarningRuleSets = idxBizPvWarningRules.stream().filter(t -> t.getAnalysisPointId().equals(idxBizPvHealthIndices.get(0).getAnalysisObjSeq())).collect(Collectors.toList());
                if (ObjectUtils.isEmpty(idxBizPvWarningRuleSets) ){
                    continue;
                }
                Double healthValueWarn = 0.0;
                Double healthValueRisk = 0.0;
                Double healthValueNotice = 0.0;

                long healthValueDayCount = 0;
                long healthValueHourCount = 0;
                long healthValueMinCount = 0;


                for (IdxBizPvWarningRuleSet e : idxBizPvWarningRuleSets) {
                    switch (e.getWarningName()){
                        case "警告":
                            healthValueWarn = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueDayCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "危险":
                            healthValueRisk = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueDayCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "注意":
                            healthValueNotice = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueDayCount =Long.parseLong(e.getWarningCycle());
                            break;
                    }

                }

                List<Double> healthIndex = idxBizPvHealthIndices.stream().map(IdxBizPvHealthIndex::getHealthIndex).collect(Collectors.toList());
                Double finalHealthValueRisk = healthValueRisk;
                long riskNum = healthIndex.stream().filter(e -> e <= finalHealthValueRisk).count();
                Double finalHealthValueWarn = healthValueWarn;
                long warnNum = healthIndex.stream().filter(e -> e <= finalHealthValueWarn).count();
                Double finalHealthValueNotice = healthValueNotice;
                long noticeNum = healthIndex.stream().filter(e -> e <= finalHealthValueNotice).count();
                String level = "";
                String content = "";
                String num = "";
                content = healthValueDayCount + "天";
                if (noticeNum >= healthValueDayCount ){
                    //    redisUtils.set(gateWayId+"_"+address+"_health_notice_day","notice");
                    level ="注意";
                    num = ""+healthValueNotice;
                }else if (warnNum >= healthValueDayCount ){
                //    redisUtils.set(gateWayId+"_"+address+"_health_warn_day","warn");
                    level ="警告";
                    num = ""+healthValueWarn;
                }else if (riskNum >= healthValueDayCount ){
                    //    redisUtils.set(gateWayId+"_"+address+"_health_risk_day","risk");
                    level ="危险";
                    num = ""+healthValueRisk;
                }
                //库里若已存在该测点预警 不生成重复的 若新生预警等级高于历史 则生成
                LambdaQueryWrapper<IdxBizPvWarningRecord> query = new LambdaQueryWrapper<>();
                query.eq(IdxBizPvWarningRecord::getAnalysisPointId,idxBizPvHealthIndices.get(0).getAnalysisObjSeq());
                query.eq(IdxBizPvWarningRecord::getStatus,0);
                query.orderByDesc(IdxBizPvWarningRecord::getRecDate);
                List<IdxBizPvWarningRecord> idxBizPvWarningRecords = idxBizPvWarningRecordMapper.selectList(query);

                int flag = ObjectUtils.isEmpty(idxBizPvWarningRecords)  || WarningNameEnum.getCode(level) > WarningNameEnum.getCode(idxBizPvWarningRecords.get(0).getWarningName()) ? 0 :1;

                if (!level.equals("") && flag == 0){
                    IdxBizPvWarningRecord idxBizPvWarningRecord = new IdxBizPvWarningRecord();
                    idxBizPvWarningRecord.setKks(idxBizPvHealthIndices.get(0).getKks());
                    idxBizPvWarningRecord.setRecord(idxBizPvHealthIndices.get(0).getRecord());
                    idxBizPvWarningRecord.setArae(idxBizPvHealthIndices.get(0).getArae());
                    idxBizPvWarningRecord.setStation(idxBizPvHealthIndices.get(0).getStation());
                    idxBizPvWarningRecord.setSubarray(idxBizPvHealthIndices.get(0).getSubarray());
                    idxBizPvWarningRecord.setGatewayId(gateWayId);
                    idxBizPvWarningRecord.setIndexAddress(address);
                    idxBizPvWarningRecord.setEquipmentName(idxBizPvHealthIndices.get(0).getEquipmentName());
                    idxBizPvWarningRecord.setAnalysisPointId(idxBizPvHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizPvWarningRecord.setDisposotionState("未处置");
                    idxBizPvWarningRecord.setStatus("0");
                    idxBizPvWarningRecord.setWarningName(level);
                    idxBizPvWarningRecord.setCONTENT(idxBizPvHealthIndices.get(0).getPointName() + "连续"+content+"健康指数<"+num );
                    idxBizPvWarningRecord.setRecDate(time);
                    idxBizPvWarningRecord.setManufacturer(idxBizPvHealthIndices.get(0).getManufacturer());
                    idxBizPvWarningRecord.setPointName(idxBizPvHealthIndices.get(0).getPointName());
                    idxBizPvWarningRecord.setHealthIndexSeq(idxBizPvHealthIndices.get(0).getHealthIndex().toString());
                    idxBizPvWarningRecord.setHealthLevel(idxBizPvHealthIndices.get(0).getHealthLevel());
                    idxBizPvWarningRecordList.add(idxBizPvWarningRecord);
                    //idxBizPvWarningRecordMapper.insert(idxBizPvWarningRecord);
                }
            }
        }
        idxBizPvWarningRecordService.saveBatch(idxBizPvWarningRecordList);
        // 触发风险模型生成预警处置模块的预警记录
        fetchDataPv(idxBizPvWarningRecordList, stationMap);
    }


  //  @Scheduled(cron = "0 0 */1 * * ?")
    @Async("async")
    public void healthWarningMinute(Calendar calendar ,Date time) {
      //  Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY,calendar.get(Calendar.HOUR_OF_DAY)-1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

        LambdaQueryWrapper<IdxBizFanHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizFanHealthIndex::getAnalysisType,"按时刻");
        wrapper.ne(IdxBizFanHealthIndex::getHealthLevel,"安全");
        wrapper.ge(IdxBizFanHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizFanHealthIndex::getRecDate);
        List<IdxBizFanHealthIndex> healthIndices = idxBizFanHealthIndexMapper.selectList(wrapper);

        if (ObjectUtils.isEmpty(healthIndices)){
            return;
        }
        List<String> collect = healthIndices.stream().map(IdxBizFanHealthIndex::getAnalysisObjSeq).collect(Collectors.toList());

        LambdaQueryWrapper<IdxBizFanWarningRuleSet> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(IdxBizFanWarningRuleSet::getAnalysisType,"按时刻");
        queryWrapper.in(IdxBizFanWarningRuleSet::getAnalysisPointId,collect);
        List<IdxBizFanWarningRuleSet> idxBizPvWarningRules = idxBizFanWarningRuleSetMapper.selectList(queryWrapper);

        Map<String, Map<String, List<IdxBizFanHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizFanHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizFanHealthIndex::getIndexAddress)));
        List<IdxBizFanWarningRecord> idxBizFanWarningRecordList = new ArrayList<>();

        HashMap<String, StationBasic> stationMap = new HashMap<>();
        for (String gateWayId : gateWayMaps.keySet()) {

            LambdaQueryWrapper<StationBasic> basicLambdaQueryWrapper = new LambdaQueryWrapper<>();
            basicLambdaQueryWrapper.eq(StationBasic::getFanGatewayId, gateWayId);
            basicLambdaQueryWrapper.last("limit 1");
            StationBasic stationBasic = stationBasicMapper.selectOne(basicLambdaQueryWrapper);
            stationMap.put(gateWayId, stationBasic);
            Map<String, List<IdxBizFanHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizFanHealthIndex> idxBizFanHealthIndices = healthDataMaps.get(address);

                List<IdxBizFanWarningRuleSet> idxBizPvWarningRuleSets = idxBizPvWarningRules.stream().filter(t -> t.getAnalysisPointId().equals(idxBizFanHealthIndices.get(0).getAnalysisObjSeq())).collect(Collectors.toList());

                if (ObjectUtils.isEmpty(idxBizPvWarningRuleSets) ){
                    continue;
                }

                Double healthValueWarn = 0.0;
                Double healthValueRisk = 0.0;
                Double healthValueNotice = 0.0;

                long healthValueDayCount = 0;
                long healthValueHourCount = 0;
                long healthValueMinCount = 0;


                for (IdxBizFanWarningRuleSet e : idxBizPvWarningRuleSets) {
                    switch (e.getWarningName()){
                        case "警告":
                            healthValueWarn = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueMinCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "危险":
                            healthValueRisk = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueMinCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "注意":
                            healthValueNotice = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueMinCount =Long.parseLong(e.getWarningCycle());
                            break;
                    }

                }



                List<Double> healthIndex = idxBizFanHealthIndices.stream().map(IdxBizFanHealthIndex::getHealthIndex).collect(Collectors.toList());
                Double finalHealthValueRisk = healthValueRisk;
                long riskNum = healthIndex.stream().filter(e -> e <= finalHealthValueRisk).count();
                Double finalHealthValueWarn = healthValueWarn;
                long warnNum = healthIndex.stream().filter(e -> e <= finalHealthValueWarn).count();
                Double finalHealthValueNotice = healthValueNotice;
                long noticeNum = healthIndex.stream().filter(e -> e <= finalHealthValueNotice).count();

                String level = "";
                String content = "";
                String num = "";
                content = healthValueMinCount*10 + "分钟";
                if (noticeNum >= healthValueMinCount ){
                    //    redisUtils.set(gateWayId+"_"+address+"_health_notice_day","notice");
                    level ="注意";
                    num = ""+healthValueNotice;
                }
                else if (warnNum >= healthValueMinCount ){
                    //    redisUtils.set(gateWayId+"_"+address+"_health_warn_day","warn");
                    level ="警告";
                    num = ""+healthValueWarn;
                }else if (riskNum >= healthValueMinCount ){
                    //    redisUtils.set(gateWayId+"_"+address+"_health_risk_day","risk");
                    level ="危险";
                    num = ""+healthValueRisk;
                }
                //库里若已存在该测点预警 不生成重复的 若新生预警等级高于历史 则生成
                LambdaQueryWrapper<IdxBizFanWarningRecord> query = new LambdaQueryWrapper<>();
                query.eq(IdxBizFanWarningRecord::getAnalysisPointId,idxBizFanHealthIndices.get(0).getAnalysisObjSeq());
                query.eq(IdxBizFanWarningRecord::getStatus,0);
                query.orderByDesc(IdxBizFanWarningRecord::getRecDate);
                List<IdxBizFanWarningRecord> idxBizFanWarningRecords = idxBizFanWarningRecordMapper.selectList(query);

                int flag = ObjectUtils.isEmpty(idxBizFanWarningRecords)  || WarningNameEnum.getCode(level) > WarningNameEnum.getCode(idxBizFanWarningRecords.get(0).getWarningName()) ? 0 :1;

                if (!level.equals("") && flag == 0){
                    IdxBizFanWarningRecord idxBizFanWarningRecord = new IdxBizFanWarningRecord();
                    idxBizFanWarningRecord.setKks(idxBizFanHealthIndices.get(0).getKks());
                    idxBizFanWarningRecord.setRecord(idxBizFanHealthIndices.get(0).getRecord());
                    idxBizFanWarningRecord.setArae(idxBizFanHealthIndices.get(0).getArae());
                    idxBizFanWarningRecord.setStation(idxBizFanHealthIndices.get(0).getStation());
                    idxBizFanWarningRecord.setSubSystem(idxBizFanHealthIndices.get(0).getSubSystem());
                    idxBizFanWarningRecord.setGatewayId(gateWayId);
                    idxBizFanWarningRecord.setIndexAddress(address);
                    idxBizFanWarningRecord.setEquipmentName(idxBizFanHealthIndices.get(0).getEquipmentName());
                    idxBizFanWarningRecord.setAnalysisPointId(idxBizFanHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizFanWarningRecord.setDisposotionState("未处置");
                    idxBizFanWarningRecord.setStatus("0");
                    idxBizFanWarningRecord.setWarningName(level);
                    idxBizFanWarningRecord.setCONTENT(idxBizFanHealthIndices.get(0).getPointName() + "连续"+content+"健康指数<"+num );
                    idxBizFanWarningRecord.setRecDate(time);
                    idxBizFanWarningRecord.setNumber(idxBizFanHealthIndices.get(0).getNumber());
                    idxBizFanWarningRecord.setPointName(idxBizFanHealthIndices.get(0).getPointName());
                    idxBizFanWarningRecord.setHealthIndexSeq(idxBizFanHealthIndices.get(0).getHealthIndex().toString());
                    idxBizFanWarningRecord.setHealthLevel(idxBizFanHealthIndices.get(0).getHealthLevel());
                    idxBizFanWarningRecordList.add(idxBizFanWarningRecord);
                    //idxBizFanWarningRecordMapper.insert(idxBizFanWarningRecord);
                }
            }
        }
        idxBizFanWarningRecordService.saveBatch(idxBizFanWarningRecordList);
        // 触发风险模型生成预警处置模块的预警记录
        fetchDataFan(idxBizFanWarningRecordList, stationMap);
    }

    /***
     * 每五小时获取一次最大粒度内的指数异常数据
     * 判断五小时内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */

    @Scheduled(cron = "0 0 0/1 * * ?")
    @Async("async")
    public void healthWarningHour() {
        Date time = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY,calendar.get(Calendar.HOUR_OF_DAY)-5);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

        LambdaQueryWrapper<IdxBizFanHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizFanHealthIndex::getAnalysisType,"按小时");
        wrapper.ne(IdxBizFanHealthIndex::getHealthLevel,"安全");
        wrapper.ge(IdxBizFanHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizFanHealthIndex::getRecDate);
        List<IdxBizFanHealthIndex> healthIndices = idxBizFanHealthIndexMapper.selectList(wrapper);
        if (ObjectUtils.isEmpty(healthIndices)){
            return;
        }
        List<String> collect = healthIndices.stream().map(IdxBizFanHealthIndex::getAnalysisObjSeq).collect(Collectors.toList());

        LambdaQueryWrapper<IdxBizFanWarningRuleSet> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(IdxBizFanWarningRuleSet::getAnalysisType,"小时");
        queryWrapper.in(IdxBizFanWarningRuleSet::getAnalysisPointId,collect);
        List<IdxBizFanWarningRuleSet> idxBizPvWarningRules = idxBizFanWarningRuleSetMapper.selectList(queryWrapper);

        Map<String, Map<String, List<IdxBizFanHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizFanHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizFanHealthIndex::getIndexAddress)));
        List<IdxBizFanWarningRecord> idxBizFanWarningRecordList = new ArrayList<>();
        HashMap<String, StationBasic> stationMap = new HashMap<>();
        for (String gateWayId : gateWayMaps.keySet()) {

            LambdaQueryWrapper<StationBasic> basicLambdaQueryWrapper = new LambdaQueryWrapper<>();
            basicLambdaQueryWrapper.eq(StationBasic::getFanGatewayId, gateWayId);
            basicLambdaQueryWrapper.last("limit 1");
            StationBasic stationBasic = stationBasicMapper.selectOne(basicLambdaQueryWrapper);
            stationMap.put(gateWayId, stationBasic);

            Map<String, List<IdxBizFanHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizFanHealthIndex> idxBizFanHealthIndices = healthDataMaps.get(address);

                List<IdxBizFanWarningRuleSet> idxBizPvWarningRuleSets = idxBizPvWarningRules.stream().filter(t -> t.getAnalysisPointId().equals(idxBizFanHealthIndices.get(0).getAnalysisObjSeq())).collect(Collectors.toList());

                if (ObjectUtils.isEmpty(idxBizPvWarningRuleSets) ){
                    continue;
                }
                Double healthValueWarn = 0.0;
                Double healthValueRisk = 0.0;
                Double healthValueNotice = 0.0;

                long healthValueDayCount = 0;
                long healthValueHourCount = 0;
                long healthValueMinCount = 0;


                for (IdxBizFanWarningRuleSet e : idxBizPvWarningRuleSets) {
                    switch (e.getWarningName()){
                        case "警告":
                            healthValueWarn = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueHourCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "危险":
                            healthValueRisk = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueHourCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "注意":
                            healthValueNotice = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueHourCount =Long.parseLong(e.getWarningCycle());
                            break;
                    }

                }



                List<Double> healthIndex = idxBizFanHealthIndices.stream().map(IdxBizFanHealthIndex::getHealthIndex).collect(Collectors.toList());
                Double finalHealthValueRisk = healthValueRisk;
                long riskNum = healthIndex.stream().filter(e -> e <= finalHealthValueRisk).count();
                Double finalHealthValueWarn = healthValueWarn;
                long warnNum = healthIndex.stream().filter(e -> e <= finalHealthValueWarn).count();
                Double finalHealthValueNotice = healthValueNotice;
                long noticeNum = healthIndex.stream().filter(e -> e <= finalHealthValueNotice).count();
                String level = "";
                String content = "";
                String num = "";
                content = healthValueHourCount + "小时";
                if(noticeNum >= healthValueHourCount ){
                    level ="注意";
                    num = ""+healthValueNotice;
                }else if (warnNum >= healthValueHourCount  ){
                    
                    level ="警告";
                    num = ""+healthValueWarn;
                }else if (riskNum >= healthValueHourCount ){
                    level ="危险";
                    num = ""+healthValueRisk;
                }
                LambdaQueryWrapper<IdxBizFanWarningRecord> query = new LambdaQueryWrapper<>();
                query.eq(IdxBizFanWarningRecord::getAnalysisPointId,idxBizFanHealthIndices.get(0).getAnalysisObjSeq());
                query.eq(IdxBizFanWarningRecord::getStatus,0);
                query.orderByDesc(IdxBizFanWarningRecord::getRecDate);
                List<IdxBizFanWarningRecord> idxBizFanWarningRecords = idxBizFanWarningRecordMapper.selectList(query);

                int flag = ObjectUtils.isEmpty(idxBizFanWarningRecords)  || WarningNameEnum.getCode(level) > WarningNameEnum.getCode(idxBizFanWarningRecords.get(0).getWarningName()) ? 0 :1;

                if (!level.equals("") && flag == 0){
                    IdxBizFanWarningRecord idxBizFanWarningRecord = new IdxBizFanWarningRecord();
                    idxBizFanWarningRecord.setKks(idxBizFanHealthIndices.get(0).getKks());
                    idxBizFanWarningRecord.setRecord(idxBizFanHealthIndices.get(0).getRecord());
                    idxBizFanWarningRecord.setArae(idxBizFanHealthIndices.get(0).getArae());
                    idxBizFanWarningRecord.setStation(idxBizFanHealthIndices.get(0).getStation());
                    idxBizFanWarningRecord.setSubSystem(idxBizFanHealthIndices.get(0).getSubSystem());
                    idxBizFanWarningRecord.setGatewayId(gateWayId);
                    idxBizFanWarningRecord.setIndexAddress(address);
                    idxBizFanWarningRecord.setEquipmentName(idxBizFanHealthIndices.get(0).getEquipmentName());
                    idxBizFanWarningRecord.setAnalysisPointId(idxBizFanHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizFanWarningRecord.setDisposotionState("未处置");
                    idxBizFanWarningRecord.setStatus("0");
                    idxBizFanWarningRecord.setWarningName(level);
                    idxBizFanWarningRecord.setCONTENT(idxBizFanHealthIndices.get(0).getPointName() + "连续"+content+"健康指数<"+num );
                    idxBizFanWarningRecord.setRecDate(time);
                    idxBizFanWarningRecord.setNumber(idxBizFanHealthIndices.get(0).getNumber());
                    idxBizFanWarningRecord.setHealthIndexSeq(idxBizFanHealthIndices.get(0).getHealthIndex().toString());
                    idxBizFanWarningRecord.setHealthLevel(idxBizFanHealthIndices.get(0).getHealthLevel());
                    idxBizFanWarningRecord.setPointName(idxBizFanHealthIndices.get(0).getPointName());
                    idxBizFanWarningRecordList.add(idxBizFanWarningRecord);
                }
            }
        }
        idxBizFanWarningRecordService.saveBatch(idxBizFanWarningRecordList);
        // 触发风险模型生成预警处置模块的预警记录
        fetchDataFan(idxBizFanWarningRecordList, stationMap);
    }

    /***
     * 每三天取一次最大粒度内的指数异常数据
     * 判断三天内数据是否符合预警规则 符合则报警并在redis中缓存 同一级别的预警记录下次不生成
     *
     */

    @Scheduled(cron = "0 0 0 0/1 * ? ")
    @Async("async")
    public void healthWarningDay() {
        Date time = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH,calendar.get(Calendar.DAY_OF_MONTH)-3);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

        LambdaQueryWrapper<IdxBizFanHealthIndex> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizFanHealthIndex::getAnalysisType,"按天");
        wrapper.ne(IdxBizFanHealthIndex::getHealthLevel,"安全");
        wrapper.ge(IdxBizFanHealthIndex::getRecDate,df.format(calendar.getTime()));
        wrapper.orderByDesc(IdxBizFanHealthIndex::getRecDate);
        List<IdxBizFanHealthIndex> healthIndices = idxBizFanHealthIndexMapper.selectList(wrapper);
        if (ObjectUtils.isEmpty(healthIndices)){
            return;
        }
        List<String> collect = healthIndices.stream().map(IdxBizFanHealthIndex::getAnalysisObjSeq).collect(Collectors.toList());

        LambdaQueryWrapper<IdxBizFanWarningRuleSet> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(IdxBizFanWarningRuleSet::getAnalysisType,"按天");
        queryWrapper.in(IdxBizFanWarningRuleSet::getAnalysisPointId,collect);
        List<IdxBizFanWarningRuleSet> idxBizPvWarningRules = idxBizFanWarningRuleSetMapper.selectList(queryWrapper);

        Map<String, Map<String, List<IdxBizFanHealthIndex>>> gateWayMaps = healthIndices.stream().collect(Collectors.groupingBy(IdxBizFanHealthIndex::getGatewayId, Collectors.groupingBy(IdxBizFanHealthIndex::getIndexAddress)));
        List<IdxBizFanWarningRecord> idxBizFanWarningRecordList = new ArrayList<>();
        HashMap<String, StationBasic> stationMap = new HashMap<>();
        for (String gateWayId : gateWayMaps.keySet()) {

            LambdaQueryWrapper<StationBasic> basicLambdaQueryWrapper = new LambdaQueryWrapper<>();
            basicLambdaQueryWrapper.eq(StationBasic::getFanGatewayId, gateWayId);
            basicLambdaQueryWrapper.last("limit 1");
            StationBasic stationBasic = stationBasicMapper.selectOne(basicLambdaQueryWrapper);
            stationMap.put(gateWayId, stationBasic);

            Map<String, List<IdxBizFanHealthIndex>> healthDataMaps = gateWayMaps.get(gateWayId);
            for (String address : healthDataMaps.keySet()) {
                List<IdxBizFanHealthIndex> idxBizFanHealthIndices = healthDataMaps.get(address);

                List<IdxBizFanWarningRuleSet> idxBizPvWarningRuleSets = idxBizPvWarningRules.stream().filter(t -> t.getAnalysisPointId().equals(idxBizFanHealthIndices.get(0).getAnalysisObjSeq())).collect(Collectors.toList());

                if (ObjectUtils.isEmpty(idxBizPvWarningRuleSets) ){
                    continue;
                }
                Double healthValueWarn = 0.0;
                Double healthValueRisk = 0.0;
                Double healthValueNotice = 0.0;

                long healthValueDayCount = 0;
 


                for (IdxBizFanWarningRuleSet e : idxBizPvWarningRuleSets) {
                    switch (e.getWarningName()){
                        case "警告":
                            healthValueWarn = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueDayCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "危险":
                            healthValueRisk = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueDayCount =Long.parseLong(e.getWarningCycle());
                            break;
                        case "注意":
                            healthValueNotice = Double.parseDouble(e.getWarningIf().substring(2));
                            healthValueDayCount =Long.parseLong(e.getWarningCycle());
                            break;
                    }

                }



                List<Double> healthIndex = idxBizFanHealthIndices.stream().map(IdxBizFanHealthIndex::getHealthIndex).collect(Collectors.toList());
                Double finalHealthValueRisk = healthValueRisk;
                long riskNum = healthIndex.stream().filter(e -> e <= finalHealthValueRisk).count();
                Double finalHealthValueWarn = healthValueWarn;
                long warnNum = healthIndex.stream().filter(e -> e <= finalHealthValueWarn).count();
                Double finalHealthValueNotice = healthValueNotice;
                long noticeNum = healthIndex.stream().filter(e -> e <= finalHealthValueNotice).count();

                String level = "";
                String content = "";
                String num = "";
                content = healthValueDayCount + "天";
                if (noticeNum >= healthValueDayCount ){
                    //    redisUtils.set(gateWayId+"_"+address+"_health_notice_day","notice");
                    level ="注意";
                    num = ""+healthValueNotice;
                }
                else if (warnNum >= healthValueDayCount ){
                //    redisUtils.set(gateWayId+"_"+address+"_health_warn_day","warn");
                    level ="警告";
                    num = ""+healthValueWarn;
                }else if (riskNum >= healthValueDayCount ){
                    //    redisUtils.set(gateWayId+"_"+address+"_health_risk_day","risk");
                    level ="危险";
                    num = ""+healthValueRisk;
                }

                LambdaQueryWrapper<IdxBizFanWarningRecord> query = new LambdaQueryWrapper<>();
                query.eq(IdxBizFanWarningRecord::getAnalysisPointId,idxBizFanHealthIndices.get(0).getAnalysisObjSeq());
                query.eq(IdxBizFanWarningRecord::getStatus,0);
                query.orderByDesc(IdxBizFanWarningRecord::getRecDate);
                List<IdxBizFanWarningRecord> idxBizFanWarningRecords = idxBizFanWarningRecordMapper.selectList(query);

                int flag = ObjectUtils.isEmpty(idxBizFanWarningRecords)  || WarningNameEnum.getCode(level) > WarningNameEnum.getCode(idxBizFanWarningRecords.get(0).getWarningName()) ? 0 :1;
                if (!level.equals("") && flag == 0){
                    IdxBizFanWarningRecord idxBizFanWarningRecord = new IdxBizFanWarningRecord();
                    idxBizFanWarningRecord.setKks(idxBizFanHealthIndices.get(0).getKks());
                    idxBizFanWarningRecord.setRecord(idxBizFanHealthIndices.get(0).getRecord());
                    idxBizFanWarningRecord.setArae(idxBizFanHealthIndices.get(0).getArae());
                    idxBizFanWarningRecord.setStation(idxBizFanHealthIndices.get(0).getStation());
                    idxBizFanWarningRecord.setSubSystem(idxBizFanHealthIndices.get(0).getSubSystem());
                    idxBizFanWarningRecord.setGatewayId(gateWayId);
                    idxBizFanWarningRecord.setIndexAddress(address);
                    idxBizFanWarningRecord.setEquipmentName(idxBizFanHealthIndices.get(0).getEquipmentName());
                    idxBizFanWarningRecord.setAnalysisPointId(idxBizFanHealthIndices.get(0).getAnalysisObjSeq());
                    idxBizFanWarningRecord.setDisposotionState("未处置");
                    idxBizFanWarningRecord.setStatus("0");
                    idxBizFanWarningRecord.setWarningName(level);
                    idxBizFanWarningRecord.setCONTENT(idxBizFanHealthIndices.get(0).getPointName() + "连续"+content+"健康指数<"+num );
                    idxBizFanWarningRecord.setRecDate(time);
                    idxBizFanWarningRecord.setNumber(idxBizFanHealthIndices.get(0).getNumber());
                    idxBizFanWarningRecord.setHealthIndexSeq(idxBizFanHealthIndices.get(0).getHealthIndex().toString());
                    idxBizFanWarningRecord.setHealthLevel(idxBizFanHealthIndices.get(0).getHealthLevel());
                    idxBizFanWarningRecord.setPointName(idxBizFanHealthIndices.get(0).getPointName());
                    idxBizFanWarningRecordList.add(idxBizFanWarningRecord);
                }
            }
        }

        idxBizFanWarningRecordService.saveBatch(idxBizFanWarningRecordList);
        // 触发风险模型生成预警处置模块的预警记录
        fetchDataFan(idxBizFanWarningRecordList, stationMap);
    }


    /**
     * 光伏 - 触发预控模型生成预警
     * @param idxBizPvWarningRecords
     * @return
     */
    @Async
    public void fetchDataPv(List<IdxBizPvWarningRecord> idxBizPvWarningRecords, HashMap<String, StationBasic> stationMap) {
        log.info("===开始触发风险预警模型===数量为：{}", idxBizPvWarningRecords.size());
        idxBizPvWarningRecords.stream().forEach(idxBizPvWarningRecord -> {
            BizMessage bizMessage = new BizMessage();
            bizMessage.setIndexKey(INDEX_KEY_PV);
            bizMessage.setIndexValue(idxBizPvWarningRecord.getPointName());
//            bizMessage.setTraceId(idxBizPvWarningRecord.getSequenceNbr());
            RiskBizInfoVo riskBizInfoVo = new RiskBizInfoVo();
            riskBizInfoVo.setWarningObjectName(idxBizPvWarningRecord.getEquipmentName());
            riskBizInfoVo.setWarningObjectCode(idxBizPvWarningRecord.getKks());
            riskBizInfoVo.setSourceAttribution(stationMap.get(idxBizPvWarningRecord.getGatewayId()).getProjectOrgCode());
            riskBizInfoVo.setSourceAttributionDesc(idxBizPvWarningRecord.getStation());
            riskBizInfoVo.setWarningObjectType("equip");
            riskBizInfoVo.setWarningTime(DateUtil.now());
            List<RiskDynamicDetailsVo> detailsVos = new ArrayList<>();
            RiskDynamicDetailsVo dynamicDetailsVo = new RiskDynamicDetailsVo();
            dynamicDetailsVo.setTabName("预警详情");
            detailsVos.add(dynamicDetailsVo);
            riskBizInfoVo.setDynamicDetails(detailsVos);
            bizMessage.setBizInfo(riskBizInfoVo);
            bizMessage.setTraceId2(idxBizPvWarningRecord.getSequenceNbr());
            try {
                emqKeeper.getMqttClient().publish(SMART_ANALYSE_PV + "/data/analysis", JSON.toJSONString(bizMessage).getBytes(StandardCharsets.UTF_8), 2, false);
            } catch (MqttException e) {
                e.printStackTrace();
            }
        });
    }


    /**
     * 风电 - 触发预控模型生成预警
     * @param idxBizFanWarningRecords
     * @return
     */
    @Async
    public void fetchDataFan(List<IdxBizFanWarningRecord> idxBizFanWarningRecords, HashMap<String, StationBasic> stationMap) {
        log.info("===开始触发风险预警模型===数量为：{}", idxBizFanWarningRecords.size());
        idxBizFanWarningRecords.stream().forEach(idxBizFanWarningRecord -> {
            BizMessage bizMessage = new BizMessage();
            bizMessage.setIndexKey(String.format(INDEX_KEY_FAN, idxBizFanWarningRecord.getNumber()));
            bizMessage.setIndexValue(idxBizFanWarningRecord.getPointName());
//            bizMessage.setTraceId(idxBizFanWarningRecord.getSequenceNbr());
            RiskBizInfoVo riskBizInfoVo = new RiskBizInfoVo();
            riskBizInfoVo.setWarningObjectName(idxBizFanWarningRecord.getEquipmentName());
            riskBizInfoVo.setWarningObjectCode(idxBizFanWarningRecord.getKks());
            riskBizInfoVo.setSourceAttribution(stationMap.get(idxBizFanWarningRecord.getGatewayId()).getProjectOrgCode());
            riskBizInfoVo.setSourceAttributionDesc(idxBizFanWarningRecord.getStation());
            riskBizInfoVo.setWarningObjectType("equip");
            riskBizInfoVo.setWarningTime(DateUtil.now());
            List<RiskDynamicDetailsVo> detailsVos = new ArrayList<>();
            RiskDynamicDetailsVo dynamicDetailsVo = new RiskDynamicDetailsVo();
            dynamicDetailsVo.setTabName("预警详情");
            detailsVos.add(dynamicDetailsVo);
            riskBizInfoVo.setDynamicDetails(detailsVos);
            bizMessage.setBizInfo(riskBizInfoVo);
            bizMessage.setTraceId2(idxBizFanWarningRecord.getSequenceNbr());
            try {
                emqKeeper.getMqttClient().publish(SMART_ANALYSE_FAN + "/data/analysis", JSON.toJSONString(bizMessage).getBytes(StandardCharsets.UTF_8), 2, false);
            } catch (MqttException e) {
                e.printStackTrace();
            }
        });
    }




}
