package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanHealthIndexDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.*;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanPointProcessVariableClassificationMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizPvPointProcessVariableClassificationMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizUxfvMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IIdxBizFanHealthIndexService;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.IndicatorDataMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import java.text.SimpleDateFormat;
import java.util.*;



/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-08-15
 */
@Service
public class IdxBizFanHealthIndexServiceImpl extends BaseService<IdxBizFanHealthIndexDto,IdxBizFanHealthIndex,IdxBizFanHealthIndexMapper> implements IIdxBizFanHealthIndexService {


   @Autowired
   IdxBizPvPointProcessVariableClassificationMapper idxBizPvPointProcessVariableClassificationMapper;

    @Autowired
    IdxBizFanPointProcessVariableClassificationMapper idxBizFanPointProcessVariableClassificationMapper;
    @Autowired
    IndicatorDataMapper indicatorDataMapper;
    /**
     * 分页查询
     */
    public Page<IdxBizFanHealthIndexDto> queryForIdxBizFanHealthIndexPage(Page<IdxBizFanHealthIndexDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<IdxBizFanHealthIndexDto> queryForIdxBizFanHealthIndexList()   {
        return this.queryForList("" , false);
    }

    public List<Map<String,Object>> queryForLeftTableList(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME, Integer current, Integer size){
    return  this.getBaseMapper().queryForLeftTableList(STATION,HEALTHLEVEL,EQUIPMENTNAME,current,size);
    }

    public int queryForLeftTableListCount(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME){
        return  this.getBaseMapper().queryForLeftTableListCount(STATION,HEALTHLEVEL,EQUIPMENTNAME);
    }

    public Map<String,Object> queryForLeftTableListNum(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME){
        return  this.getBaseMapper().queryForLeftTableListNum(STATION,HEALTHLEVEL,EQUIPMENTNAME);
    }




    public  Object getqyt(String type,String address,String statioName,String equipmentName, String  arae,String startTime,String endTime){
        Map<String, Object> map = new HashMap<>();
        try {
           //获取场站网关
        String tdid=null;
     if(type.equals("1")){
         IdxBizPvPointProcessVariableClassification      idxBizPvPointProcessVariableClassification=  idxBizPvPointProcessVariableClassificationMapper.selectOne(
                 new QueryWrapper<IdxBizPvPointProcessVariableClassification>()
                         .eq("INDEX_ADDRESS", address)
                         .eq("STATION", statioName)
                         .eq("EQUIPMENT_NAME", equipmentName)
                         .eq("ARAE", arae)
                         .last("limit 1")
         );
         tdid=address+"_"+idxBizPvPointProcessVariableClassification.getGatewayId();
     }else{
         IdxBizFanPointProcessVariableClassification idxBizFanPointProcessVariableClassification=   idxBizFanPointProcessVariableClassificationMapper.selectOne(
                 new QueryWrapper<IdxBizFanPointProcessVariableClassification>()
                         .eq("INDEX_ADDRESS", address)
                         .eq("STATION", statioName)
                         .eq("EQUIPMENT_NAME", equipmentName)
                         .eq("ARAE", arae)
                         .last("limit 1")
         );
         tdid=address+"_"+idxBizFanPointProcessVariableClassification.getGatewayId();
     }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
    //限制必须是区间时间段
    if(startTime==null||endTime==null){

        Date currentDayStartTime = DateUtils.getCurrentDayStartTime(new Date());
         Date currentDayEndTime = DateUtils.getCurrentDayEndTime(new Date());

         startTime = sdf.format(currentDayStartTime);
         endTime= sdf.format(currentDayEndTime);
    }else{
        Date currentDayStartTime =dateFormat.parse(startTime);
        Date currentDayEndTime = dateFormat.parse(endTime);
        startTime = sdf.format(currentDayStartTime);
        endTime= sdf.format(currentDayEndTime);
    }
        List<IndicatorData> indicatorDataListActivePowers = new ArrayList<>();
        indicatorDataListActivePowers= indicatorDataMapper.selectDataByequipmentIndexNameAndtimeAndEquipmentNumber(tdid,startTime,endTime);
        List<String> axisData = new ArrayList<>();
        List<String> activePowers = new ArrayList<>();
        for (int i = 0; i < indicatorDataListActivePowers.size(); i++) {
            activePowers.add(indicatorDataListActivePowers.get(i).getValue());
            axisData.add(DateUtil.format(indicatorDataListActivePowers.get(i).getCreatedTime(), "yyyy-MM-dd HH:mm:ss"));
        }
       // List<Map<String, Object>> seriesData = new ArrayList<>();

//        Map<String, Object> map2 = new HashMap<>();
//        map2.put("data", activePowers);
//        seriesData.add(map2);
        map.put("seriesData", activePowers);
        map.put("axisData", axisData);
     }catch (Exception e){
         e.printStackTrace();
         throw new RuntimeException();
     }
    return map;
    }



    public List<Map<String,Object>> queryForLeftTableListByPoint(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME,  String POINTNAME,Integer current, Integer size){
        return  this.getBaseMapper().queryForLeftTableListByPoint(STATION,HEALTHLEVEL,EQUIPMENTNAME,POINTNAME,current,size);
    }

    public int queryForLeftTableListByPointCount(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME,String POINTNAME){
        return  this.getBaseMapper().queryForLeftTableListByPointCount(STATION,HEALTHLEVEL,EQUIPMENTNAME,POINTNAME);
    }

    public Map<String,Object> queryForLeftTableListByPointNum(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME,String POINTNAME){
        return  this.getBaseMapper().queryForLeftTableListByPointNum(STATION,HEALTHLEVEL,EQUIPMENTNAME,POINTNAME);
    }

    public int pointNum(String STATION, String SUBARRAY,String EQUIPMENTNAME) {
        return this.getBaseMapper().pointNum(STATION, SUBARRAY,EQUIPMENTNAME);
    }

    public  List<IdxBizFanWarningRecord> warningData(String STATION, String SUBARRAY , String EQUIPMENTNAME) {
        return this.getBaseMapper().warningData(STATION, SUBARRAY, EQUIPMENTNAME);
    }



}