package com.yeejoin.amos.boot.module.jxiop.api.dto;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.CommonFile;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 户用光伏合同表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="HouseholdPvInstallDto", description="户用光伏合同表")
public class HouseholdPvInstallDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "户用光伏id")
    private Long householdPvId;

    @ApiModelProperty(value = "所属厂站")
    private String platformCompanyId;

    @ApiModelProperty(value = "安装信息描述")
    private String description;

    @ApiModelProperty(value = "基础框架整体安装照片")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> foundationFramePhoto;

    @ApiModelProperty(value = "组件铭牌安装照片")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> nameplatePhoto;

    @ApiModelProperty(value = "配电箱、逆变器案场安装照片")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> distributionBoxInverterPhoto;

    @ApiModelProperty(value = "电表照片")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> electricityMeterPhoto;

    @ApiModelProperty(value = "其他照片")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> otherPhoto;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

}
