package com.yeejoin.amos.boot.module.jxiop.api.feign;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(name = "${mcb.warning.name:MCB-SERVER}", path = "risk", configuration = {FeignConfiguration.class})
public interface RiskWarningFeign {


    /**
     * 根据风险来源查询人员红黄绿吗信息
     */
    @GetMapping("/model-risk-handle/getRiskHandleByVarDesc")
    FeignClientResult<List<String>> getRiskHandleByVarDesc(@RequestParam(required = false, value = "varDesc") String varDesc);


}
