package com.yeejoin.amos.boot.module.jxiop.biz.tasks;

import cn.hutool.http.HttpUtil;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationBasicDto;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.StationBasicServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.StationDataTaskImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @description: 定时获取场站最新数据
 * @author: tw
 * @createDate: 2023/7/3
 */

@Component
@EnableScheduling
@Slf4j
public class BigScreenTask {

    @Autowired
    StationDataTaskImpl stationDataTask;

    @Autowired
    StationBasicServiceImpl stationBasicService;

    @Value("${idx.predict.serviceUrl:http://139.9.173.44:8095/jxdj/predict-data}")
    private String predictServiceUrl;


    /**
     * 生成预测数据，平台大屏预测折线图使用，原有iframe集成算法预测数据PC端使用，
     * 但是大屏也需使用此功能，由于算法折线图样式与大屏风格不一致，故新画页面查询算法的预测表，
     * 但是算法服务只有调用查询，才生成数据，所以必须调用，否则大屏查询无预测数据
     */
    @Scheduled(cron = "0 0/20 * * * ?")
    public void predictDataCreate() {
        List<StationBasicDto> stations = stationBasicService.getBaseMapper().getStationBasicListAll();
        stations.forEach(s -> {
            try {
                String url = String.format("%s?code=%s", predictServiceUrl, s.getProjectOrgCode());
                HttpUtil.get(url);
            } catch (Exception e) {
                log.error("调用算法定时生成大屏评估预测数据失败：机构{},错误信息：{}", s.getProjectOrgCode(), e.getMessage());
            }
        });
    }

}
