package com.yeejoin.precontrol.common.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.PersonAscription;
import com.yeejoin.precontrol.common.entity.PersonExam;
import com.yeejoin.precontrol.common.enums.SmallProQrColorEum;
import com.yeejoin.precontrol.common.enums.TaskTypeEnum;
import com.yeejoin.precontrol.common.exception.BaseException;
import com.yeejoin.precontrol.common.service.IPersonAccessService;
import com.yeejoin.precontrol.common.service.IPersonAscriptionService;
import com.yeejoin.precontrol.common.service.IPersonExamService;
import com.yeejoin.precontrol.common.service.IProjectHistoryService;
import com.yeejoin.precontrol.common.service.ITaskPersonFileService;
import com.yeejoin.precontrol.common.service.ITaskPersonService;
@Service
public class PersonAccessServiceImpl implements IPersonAccessService {

	/**
	 * 项目历史服务
	 */
	@Autowired
	IProjectHistoryService iProjectHistoryService;

	/**
	 * 任务与附件服务
	 */
	@Autowired
	ITaskPersonFileService iTaskPersonFileService;

	/**
	 * 任务与人员服务
	 */
	@Autowired
	ITaskPersonService iTaskPersonService;

	/**
	 * 任务与人员服务
	 */
	@Autowired
	IPersonAscriptionService iPersonAscriptionService;

	/**
	 * 考试服务
	 */
	@Autowired
	IPersonExamService iPersonExamService;

	@Override
	public void enterJudge(Person person,Long projectId) throws BaseException {
		// 黑名单不允许入场打卡
		if (person.getIsBlack() == 1) {
			throw new BaseException("入场失败,该人员属于黑名单");
		}
		// 红码不允许入场打卡
		if (person.getColor() == SmallProQrColorEum.red.getSqlCode()) {
			throw new BaseException("入场失败,该人员属于红码状态");
		}
		// 加判断 判断当前项目 如果离岗了 不准打卡
		PersonAscription personAscription = iPersonAscriptionService
				.getOne(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId, person.getId()));
		if (personAscription == null || personAscription.getProjectId() == null) {
			throw new BaseException("入场失败，请先入岗打卡");
		}
		// 判断上岗是否和入场项目一样
		if(projectId!=null&&!projectId.equals(personAscription.getProjectId())) 
		{
			throw new BaseException("入场失败，该人员上岗项目和入场项目不一致");
		}
		int count = iTaskPersonService.noReadCount(person.getId(), TaskTypeEnum.KNOWLEDGE_SHARE.getValue(), null);
		if (count > 0) {
			throw new BaseException("入场失败，请先完成未处理的知识分享任务");
		}

		// 2021.1.19需求变更 三级安全考试不通过，可以入岗，但不可以入场；
		if (!person.getIsJxdj().equals(1L)) {
			// 安全考试未通过不允许上岗打卡
			SFunction<PersonExam, ?> column = PersonExam::getCreateDate;
			PersonExam personExam = iPersonExamService.getOne(new LambdaQueryWrapper<PersonExam>()
					.eq(PersonExam::getPersonId, person.getId()).eq(PersonExam::getExamSubjectType, "THREE_LEVEL_EXAM")
					.orderByDesc(column).last("LIMIT 1"));
			if (personExam == null) {
				throw new BaseException("入场失败,该人员未进行三级安全教育考试");
			}
			if (personExam != null && !personExam.getQualified()) {
				throw new BaseException("入场失败,该人员最近一次三级安全教育考试不合格");
			}
		}
	}
}
