package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.UserEvaluationLog;
import com.yeejoin.precontrol.common.mapper.UserEvaluationLogMapper;
import com.yeejoin.precontrol.common.service.IUserEvaluationLogService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 用户评价记录表 服务实现类
 *
 * @author tb
 * @date 2021-01-28
 */
@Service
public class UserEvaluationLogServiceImpl extends ServiceImpl<UserEvaluationLogMapper, UserEvaluationLog> implements IUserEvaluationLogService {

    @Override
    public IPage<UserEvaluationLog> listByPersonId(String pageNum, String pageSize, String personId) {
        Page<UserEvaluationLog> pageBean;
        QueryWrapper<UserEvaluationLog> userEvaluationLogQueryWrapper = new QueryWrapper<>();
        userEvaluationLogQueryWrapper.lambda().eq(UserEvaluationLog::getPersonId, personId);
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        IPage<UserEvaluationLog> page = this.page(pageBean, userEvaluationLogQueryWrapper);
        return page;
    }

    @Override
    public List<UserEvaluationLog> listByTaskId(String taskId) {
        QueryWrapper<UserEvaluationLog> userEvaluationLogQueryWrapper = new QueryWrapper<>();
        userEvaluationLogQueryWrapper.lambda().eq(UserEvaluationLog::getTaskId, taskId);
        return this.baseMapper.selectList(userEvaluationLogQueryWrapper);
    }
}
