package com.yeejoin.precontrol.common.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 用户评价记录表
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Data
@Accessors(chain = true)
@TableName("rpm_user_evaluation_log")
@ApiModel(value = "UserEvaluationLogVo", description = "用户评价记录表")
public class UserEvaluationLogVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户id")
    private Long personId;

    @ApiModelProperty(value = "评价人id")
    private Long evaluationUserId;

    @ApiModelProperty(value = "评价人名称")
    private String evaluationUserName;

    @ApiModelProperty(value = "评价内容")
    private String content;

    @ApiModelProperty(value = "评价等级")
    private Integer rate;
    
    @ApiModelProperty(value = "任务id")
    private Long taskId;
    
    @ApiModelProperty(value = "用户名称")
    private String personName;
    
    @ApiModelProperty(value = "用户图片")
    @ImagePrefix
    private String photo;
}
