package com.yeejoin.precontrol.controller;

import com.yeejoin.precontrol.common.enums.TaskStatusEnum;
import com.yeejoin.precontrol.common.enums.TaskTypeEnum;
import com.yeejoin.precontrol.common.service.IBaseService;
import com.yeejoin.precontrol.common.service.SmallProService;
import com.yeejoin.precontrol.common.utils.CommonResponseUtil;
import com.yeejoin.precontrol.common.utils.RedisUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 项目信息
 *
 * @author duanwei
 * @date 2020-06-30
 */
@RestController
@Api(tags = "公共API")
@RequestMapping(value = "/common", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class CommonController {

    /**
     * 小程序应用id
     */
    @Value("${smallProgram.appid}")
    private String appId;
    /**
     * 小程序应用secret
     */
    @Value("${smallProgram.secret}")
    private String secret;

    /**
     * 缓存工具类
     */
    @Autowired
    RedisUtil redisUtil;
    /**
     * 通用查询服务
     */
    @Autowired
    IBaseService iBaseService;
    /**
     * 小程序服务
     */
    @Autowired
    SmallProService smallProService;


    /**
     * 获取token
     *
     * @return
     */
    @RequestMapping(value = "/getToken", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取token", notes = "获取token")
    public Object getToken() {
        String token = smallProService.getSmallProToken();
        return token;
    }

    /**
     * 通过code换 请求openId链接
     *
     * @return
     */
    @RequestMapping(value = "/exchangeSmallProMesssage", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "通过code换 请求openId链接", notes = "通过code换 请求openId链接")
    public Object exchangeSmallProMesssage(String json_code) {
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid=" + appId + "&secret=" + secret + "&js_code=" + json_code
                + "&grant_type=authorization_code";
        return url;
    }

    /**
     * 获取作业活动类型
     * @return
     */
    @GetMapping(value = "get/activity/type")
    @ApiOperation(value = "获取作业活动类型", notes = "获取作业活动类型")
    public Object getActivityType() {
        TaskTypeEnum[] values = TaskTypeEnum.values();
        List<Map<String, Object>> list = new ArrayList<>();
        for (TaskTypeEnum value : values) {
            if(value.getValue().equals(4L)){
                continue;
            }
            Map<String, Object> map = new HashMap();
            map.put("key",value.getValue());
            map.put("value", value.getLabel());
            list.add(map);
        }
        return CommonResponseUtil.success(list);
    }

    /**
     * 获取作业活动状态
     * @return
     */
    @GetMapping(value = "get/activity/status")
    @ApiOperation(value = "获取作业活动状态", notes = "获取作业活动状态")
    public Object getActivityStatus() {
        TaskStatusEnum[] values = TaskStatusEnum.values();
        List<Map<String, Object>> list = new ArrayList<>();
        for (TaskStatusEnum value : values) {
            Map<String, Object> map = new HashMap();
            map.put("key",value.getType());
            map.put("value", value.getName());
            list.add(map);
        }
        return CommonResponseUtil.success(list);
    }

}
