package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.tzs.api.entity.UserCheckStatus;
import com.yeejoin.amos.boot.module.tzs.api.service.IUserCheckStatusService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 装备分类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@RestController
@Api(tags = "首页弹窗提示")
@RequestMapping(value = "/user-check")
public class UserCheckStatusController extends BaseController {

	@Autowired
	IUserCheckStatusService userCheckStatusService;

	@Autowired
	RedisUtils redisUtils;

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getUserCheckStatus", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取用户是否点击下次不在提示", notes = "获取用户是否点击下次不在提示")
	public ResponseModel<UserCheckStatus> getUserCheckStatus() {
		ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
		if (ObjectUtils.isEmpty(reginParams)) {
			return null;
		}
		return ResponseHelper.buildResponse(userCheckStatusService.getUserCheckStatus(reginParams));
	}

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/updateUserCheckStatus", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "更改用户选择状态", notes = "更改用户选择状态")
	public ResponseModel<UserCheckStatus> updateUserCheckStatus(@RequestParam(value = "status") String status) {
		ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
		if (ObjectUtils.isEmpty(reginParams)) {
			return null;
		}
		String useName = reginParams.getUserModel().getUserName();
		return ResponseHelper.buildResponse(userCheckStatusService.updateUserCheckStatus(useName,status));
	}


}
