package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 材料信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MaterialDto", description="材料信息表")
public class ProjectMaterialDto extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "企业id")
    private Long companyId;

    @ApiModelProperty(value = "管材编号")
    private String code;

    @ApiModelProperty(value = "管材类别")
    private String type;

    @ApiModelProperty(value = "管材规格")
    private String spec;

    @ApiModelProperty(value = "管材壁厚")
    private Integer wallThickness;

    @ApiModelProperty(value = "生产厂家")
    private String manufacturer;

    @ApiModelProperty(value = "生产日期")
    private Date manufactureDate;

    @ApiModelProperty(value = "生产编号")
    private String batchNum;

    @ApiModelProperty(value = "管道直径")
    private Double diameter;

    @ApiModelProperty(value = "管道材料")
    private String material;

    @ApiModelProperty(value = "管道长度")
    private Double length;

    @ApiModelProperty(value = "厂家所在地")
    private String manufactureAddr;

    @ApiModelProperty(value = "是否审批通过（1通过，0未通过）")
    private Boolean approved;

    @ApiModelProperty(value = "单位机构代码")
    private String orgCode;

    @ApiModelProperty(value = "项目名称")
    private String  projectName;

    @ApiModelProperty(value = "项目资源id")
    private Long  projectResourceId;
}
