package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_ugp_pipe")
public class Pipe extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 管段名称
     */
    @TableField("pipe_name")
    private String pipeName;
    /**
     * 施工图号
     */
    @TableField("construction_drawing_num")
    private String constructionDrawingNum;
    /**
     * 管段编号
     */
    @TableField("pipe_code")
    private String pipeCode;
    /**
     * 管段级别
     */
    @TableField("pipe_level")
    private String pipeLevel;
    /**
     * 管段起点（经纬度）
     */
    @TableField("start_position")
    private String startPosition;
    /**
     * 管段终点（经纬度）
     */
    @TableField("end_position")
    private String endPosition;
    /**
     * 管段长度
     */
    @TableField("length")
    private Float length;
    /**
     * 材质
     */
    @TableField("material")
    private String material;
    /**
     * 规格
     */
    @TableField("specification")
    private String specification;
    /**
     * 设计压力
     */
    @TableField("design_pressure")
    private Float designPressure;
    /**
     * 设计温度
     */
    @TableField("design_temperature")
    private Float designTemperature;
    /**
     * 介质
     */
    @TableField("medium")
    private String medium;
    /**
     * 关联项目id
     */
    @TableField("project_id")
    private Long projectId;
    /**
     * 起点名称
     */
    @TableField("start_name")
    private String startName;
    /**
     * 终点名称
     */
    @TableField("end_name")
    private String endName;
}
