package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 质量问题表
 *
 * @author system_generator
 * @date 2022-09-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_ugp_quality_problem")
public class QualityProblem extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 项目id
     */
	@TableField("project_id")
    private Long projectId;

    /**
     * 质量问题编号
     */
	@TableField("code")
    private String code;

    /**
     * 问题产生阶段
     */
	@TableField("generate_stage")
    private String generateStage;

    /**
     * 问题描述
     */
	@TableField("problem_describe")
    private String problemDescribe;

    /**
     * 问题等级
     */
	@TableField("level")
    private String level;

    /**
     * 产生问题的阶段对应检验信息id
     */
	@TableField("stage_verify_id")
    private Long stageVerifyId;

    /**
     * 处理进度
     */
	@TableField("process_progress")
    private String processProgress;

    /**
     * 整改书提交状态（1已提交/0未提交）
     */
	@TableField("submit_status")
    private Boolean submitStatus;

    /**
     * 问题提交日期
     */
	@TableField("submit_date")
    private Date submitDate;

    /**
     * 问题分类（1继续整改/2转问题处理单）
     */
	@TableField("problem_type")
    private Boolean problemType;

    /**
     * 审查项目是否存在问题（1是/0否）
     */
	@TableField("review_status")
    private Boolean reviewStatus;

    /**
     * 处理方案（附件上传）
     */
	@TableField("solution")
    private String solution;

    /**
     * 处理方案说明
     */
	@TableField("solution_desc")
    private String solutionDesc;

    /**
     * 处理意见（附件上传）
     */
	@TableField("handing_opinion")
    private String handingOpinion;

    /**
     * 处理意见说明
     */
	@TableField("handing_opinion_desc")
    private String handingOpinionDesc;

    /**
     * 整改书（附件上传）
     */
	@TableField("reform_doc")
    private String reformDoc;

    /**
     * 整改书说明
     */
	@TableField("reform_desc")
    private String reformDesc;

    /**
     * 整改期限
     */
	@TableField("reform_limit_date")
    @JsonFormat(pattern ="yyyy-MM-dd", timezone ="GMT+8")
    private Date reformLimitDate;

    /**
     * 是否限期内整改（1是/0否）
     */
	@TableField("rectify_within_time")
    private Boolean rectifyWithinTime;

    /**
     * 流程id
     */
	private String instanceId;
    /**
     * 流程状态
     */
	private String status;

    /**
     * 问题来源
     */
    @TableField("come_from")
	private String comeFrom;

    /**
     * 系统联络单
     */
    @TableField("system_contact_sheet")
    private String systemContactSheet;

    /**
     * 意见书
     */
    @TableField("submission")
    private String submission;
}
