package com.yeejoin.amos.boot.module.ugp.biz.fegin;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 数据集成服务接口feign
 *
 * @author Dell
 */
@FeignClient(name = "${maas.feign.name:maas-mdm}", path = "maas", configuration =
		{MultipartSupportConfig.class})
public interface MaasServiceFeignClient {

	/**
	 * 获取图片识别数据
	 *
	 * @param param
	 * @return
	 */
	@RequestMapping(value = "/maas/processes/api/" + "${maas.service.ocr.id}", method = RequestMethod.POST)
	ResponseModel<Object> execProcessApiByServiceId(@RequestBody Object param);

}
