package com.yeejoin.amos.boot.biz.common.utils;

import java.util.Map;
import java.util.HashMap;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;


/**
 * Created by magintursh on 2017-06-26.
 */
public class CustomerGenerator {
    /**
     * <p>
     * MySQL 生成演示
     * </p>
     */
   public static void main(String[] args) {

        AutoGenerator mpg = new AutoGenerator();

        // 全局配置
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir("D://tyboot-generator//");
//        gc.setOutputDir("/home/magintursh/tyboot-generator");
        gc.setFileOverride(true);
        gc.setActiveRecord(true);
        gc.setEnableCache(false);// XML 二级缓存
        gc.setBaseResultMap(true);// XML ResultMap
        gc.setBaseColumnList(false);// XML columList
        gc.setAuthor("Gaudey");

        // 自定义文件命名，注意 %s 会自动填充表实体属性！
        // gc.setMapperName("%sDao");
        // gc.setXmlName("%sDao");
        gc.setServiceName("%sService");
        gc.setServiceImplName("%sModel");
        gc.setControllerName("%sResource");
        mpg.setGlobalConfig(gc);

        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setDbType(DbType.MYSQL);
        dsc.setDriverName("com.mysql.cj.jdbc.Driver");
//        dsc.setUsername("iot_platform");
//        dsc.setPassword("iot_platform");
//        dsc.setUrl("jdbc:mysql://mysql8.share.paas.yeeamos.com:53315/iot_platform?serverTimezone=Asia/Shanghai");

        dsc.setUsername("root");
        dsc.setPassword("admin_1234");
        dsc.setUrl("jdbc:mysql://172.16.11.33:3306/iot_platform?serverTimezone=Asia/Shanghai");
        mpg.setDataSource(dsc);

        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        strategy.setTablePrefix(new String [] {"auth_"});// 此处可以修改为您的表前缀
        strategy.setNaming(NamingStrategy.underline_to_camel);// 表名生成策略
        // strategy.setInclude(new String[] { "user" }); // 需要生成的表
        // strategy.setExclude(new String[]{"test"}); // 排除生成的表
        // 字段名生成策略
        //strategy.setFieldNaming(NamingStrategy.underline_to_camel);
        strategy.setNaming(NamingStrategy.underline_to_camel);

        // 自定义实体父类
        strategy.setSuperEntityClass("org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity");
        // 自定义实体，公共字段
        strategy.setSuperEntityColumns(new String[] { "SEQUENCE_NBR", "REC_DATE","REC_USER_ID","REC_STATUS","EXTEND1","EXTEND2","EXTEND3","DESCRIPTION" });
        // 自定义 mapper 父类
        // strategy.setSuperMapperClass("com.baomidou.demo.TestMapper");
        // 自定义 service 父类
        //strategy.setSuperServiceClass("org.typroject.tyboot.core.rdbms.service");
        // 自定义 service 实现类父类
        // strategy.setSuperServiceImplClass("com.baomidou.demo.TestServiceImpl");
        // 自定义 controller 父类
        // strategy.setSuperControllerClass("com.baomidou.demo.TestController");
        // 【实体】是否生成字段常量（默认 false）
        // public static final String ID = "test_id";
        // strategy.setEntityColumnConstant(true);
        // 【实体】是否为构建者模型（默认 false）
        // public User setName(String name) {this.name = name; return this;}
        //strategy.setEntityBuliderModel(true);
        mpg.setStrategy(strategy);

        // 包配置
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("iot");

        pc.setParent("com.yeejoin.amos");
        pc.setEntity("face.orm.entity");
        pc.setMapper("face.orm.dao");
        pc.setController("controller");
        pc.setService("face.service");
        pc.setServiceImpl("face.model");

        mpg.setPackageInfo(pc);

        // 注入自定义配置，可以在 VM 中使用 cfg.abc 设置的值
        InjectionConfig cfg = new InjectionConfig() {
            @Override
            public void initMap() {
                Map<String, Object> map = new HashMap<String, Object>();
                map.put("abc", this.getConfig().getGlobalConfig().getAuthor() + "-mp");
                this.setMap(map);
            }
        };
        mpg.setCfg(cfg);

        // 自定义模板配置
        TemplateConfig tc = new TemplateConfig();

        tc.setController("template/controller.java.vm");
        tc.setEntity("template/entity.java.vm");
        tc.setMapper("template/mapper.java.vm");
        tc.setXml("template/mapper.xml.vm");
        tc.setService("template/service.java.vm");
        tc.setServiceImpl("template/model.java.vm");

        // tc.setServiceImpl("...");
        mpg.setTemplate(tc);

        // 执行生成
        mpg.execute();

        // 打印注入设置
        System.err.println(mpg.getCfg().getMap().get("abc"));
    }


}