package com.yeejoin.amos.boot.biz.common.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
/**
 * 生成树工具类
 * @return
 * <PRE>
 * author tw
 * date 2021/6/10
 * </PRE>
 */
public class TreeParser{  
	/**
	 * @param topId  父id
	 * @param entityList  数据集合
	 * @param packageURL 集合对象包名+类名
	 * @param IDMethodName  集合对象获取树id 方法名
	 * @param IDHierarchy  集合对象获取树id 来源于自己 还是父级(  1自己，2 父级 ，3 父级的父级)
	 * @param NAMEMethodName 集合对象获取树name 方法名
	 * @param PARENTIDMethodName 集合对象获取树父id 方法名
	 * @return java.util.List<com.yeejoin.amos.boot.module.jcs.api.vo.Menu>
	 * <PRE>
	 * author tw
	 * date 2021/6/10
	 * </PRE>
	 */
	@SuppressWarnings("unchecked")
	public static List<Menu> getTree(Long topId, @SuppressWarnings("rawtypes") Collection entityList,String packageURL,String IDMethodName,int IDHierarchy, String NAMEMethodName,String PARENTIDMethodName ) throws Exception{
        List<Menu> resultList=new ArrayList<>();
        @SuppressWarnings("rawtypes")
		Class clazz=  Class.forName(packageURL);
        Method IDMethodNameme = null;
        switch (IDHierarchy) { case 1:
			IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
			break;
        case 2:
        	IDMethodNameme = clazz.getSuperclass().getDeclaredMethod(IDMethodName);
			break;
        case 3:
        	IDMethodNameme = clazz.getSuperclass().getSuperclass().getDeclaredMethod(IDMethodName);
	        break;
		default:
			IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
			break;
		}
    	
     	Method NAMEMethodNameme =     clazz.getDeclaredMethod(NAMEMethodName);
     	Method PARENTIDMethodNameme = clazz.getDeclaredMethod(PARENTIDMethodName);
        //获取顶层元素集合  
     	 Long parentId; 
        for (Object ob : entityList) {  
       
        	Object entity = clazz.cast(ob);         	
        	
        	   parentId=PARENTIDMethodNameme.invoke(entity)!=null? Long.valueOf(String.valueOf(PARENTIDMethodNameme.invoke(entity))):null;	
        	      
            if(parentId==null||topId==parentId){  
            	Menu menu=new Menu(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId);
                resultList.add(menu);  
            }  
        }           
        //获取每个顶层元素的子数据集合  
        for (Menu entity : resultList) {  
            entity.setChildren(getSub(entity.getId(), entityList, packageURL, IDMethodName,IDHierarchy, NAMEMethodName, PARENTIDMethodName));  
        }  
          
        return resultList;   
    }  
      
    /** 
     * 获取子数据集合 
     */  
    @SuppressWarnings("unchecked")
	private  static List<Menu> getSub(Long topId, @SuppressWarnings("rawtypes") Collection entityList,String packageURL,String IDMethodName,int IDHierarchy,String NAMEMethodName,String PARENTIDMethodName ) throws Exception{  
    	  List<Menu> childList=new ArrayList<>();   
         @SuppressWarnings("rawtypes")
		Class clazz=  Class.forName(packageURL);
         Method IDMethodNameme = null;
         switch (IDHierarchy) {
 		case 1:
 			IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
 			break;
         case 2:
         	IDMethodNameme = clazz.getSuperclass().getDeclaredMethod(IDMethodName);
 			break;
         case 3:
         	IDMethodNameme = clazz.getSuperclass().getSuperclass().getDeclaredMethod(IDMethodName);
 	    break;
 		default:
 			IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
 			break;
 		}
     	Method NAMEMethodNameme =  clazz.getDeclaredMethod(NAMEMethodName);
     	Method PARENTIDMethodNameme = clazz.getDeclaredMethod(PARENTIDMethodName);
     	 Long parentId;   
        //子集的直接子对象  
     	 for (Object ob : entityList) { 
     		Object entity = clazz.cast(ob);     
    		
     	   parentId=PARENTIDMethodNameme.invoke(entity)!=null? Long.valueOf(String.valueOf(PARENTIDMethodNameme.invoke(entity))):null;	
     	   
     	   if(parentId==null) {
     		  if(topId==parentId){  
                 	Menu menu=new Menu(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId);
                 	childList.add(menu);  
                 }  
     	   }else {
     		  if(topId.longValue()==parentId.longValue()){  
               	Menu menu=new Menu(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId);
               	childList.add(menu);  
               }     
     	   }
            
        }  
          
        //子集的间接子对象  
        for (Menu entity : childList) {  
            entity.setChildren(getSub(entity.getId(), entityList, packageURL, IDMethodName,IDHierarchy, NAMEMethodName, PARENTIDMethodName));  
        }  
          
        //递归退出条件  
        if(childList.size()==0){  
            return null;  
        }  
          
        return childList;  
    } 
} 
