package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
* 
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_alert_form_value")
@ApiModel(value="AlertFormValue对象", description="")
public class AlertFormValue extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "表单id")
    private Long alertFormId;

    @ApiModelProperty(value = "警情id")
    private Long alertCalledId;

    @ApiModelProperty(value = "警情类型")
    private String alertTypeCode;

    @ApiModelProperty(value = "字段名称")
    private String fieldName;

    @ApiModelProperty(value = "英文名称")
    private String fieldCode;

    @ApiModelProperty(value = "字段值")
    private String fieldValue;

    @ApiModelProperty(value = "字段值字典code")
    private String fieldValueCode;

    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

    @ApiModelProperty(value = "是否一行显示")
    private boolean isBlock;

	public AlertFormValue() {
		super();
	}

    public AlertFormValue(Long alertFormId, String fieldName, String fieldCode, boolean isBlock) {
        this.alertFormId = alertFormId;
        this.fieldName = fieldName;
        this.fieldCode = fieldCode;
        this.isBlock = isBlock;
    }
}
