package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
/**
* 
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_fire_experts")
@ApiModel(value="FireExperts对象", description="")
public class FireExperts extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "证件类型")
    private String documentType;

    @ApiModelProperty(value = "证件号")
    private Long documentNum;

    @ApiModelProperty(value = "单位")
    private String unitsName;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "名族")
    private String national;

    @ApiModelProperty(value = "籍贯")
    private String nativePlace;

    @ApiModelProperty(value = "现居住地")
    private String theLatter;

    @ApiModelProperty(value = "政治面貌")
    private String politicalLandscape;

    @ApiModelProperty(value = "学历")
    private String educationBackground;

    @ApiModelProperty(value = "岗位名称")
    private String jobs;

    @ApiModelProperty(value = "领域")
    private String field;

    @ApiModelProperty(value = "是否内部专家")
    private Boolean isnoInternal;

    @ApiModelProperty(value = "消防机构id")
    private Long fireTeamId;

    @ApiModelProperty(value = "公用 电话")
    private String officePhone;

    @ApiModelProperty(value = "移动电话")
    private String mobilePhone;

    @ApiModelProperty(value = "更新时间")
    @TableField(fill=FieldFill.UPDATE)
    private Date updateTime;

    @ApiModelProperty(value = "操作人名称")
    @TableField(fill=FieldFill.INSERT_UPDATE)
    private String recUserName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "备注")
    private String note;

}
