package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
/**
* 消防人员配装记录
*
* @author tb
* @date 2021-06-07
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_firefighters_jacket")
@ApiModel(value="FirefightersJacket对象", description="消防人员配装记录")
public class FirefightersJacket extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "消防队员")
    private Long firefightersId;

    @ApiModelProperty(value = "装备id")
    private Long equipmentDetailId;

    @ApiModelProperty(value = "装备数量")
    private Double amount;

    @ApiModelProperty(value = "装备计量单位")
    private String unit;

    @ApiModelProperty(value = "装备库存明细id")
    private Long stockDetailId;
    
    
    @ApiModelProperty(value = "装备名称")
    private String equipmentDetailName;

    @ApiModelProperty(value = "装备分类名称")
    private String equipmentTypeName;

    @ApiModelProperty(value = "配发日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @TableField(fill=FieldFill.INSERT_UPDATE)
    private Date allotmentTime;

    @ApiModelProperty(value = "更新时间")
    @TableField(fill=FieldFill.UPDATE)
    private Date updateTime;

    @ApiModelProperty(value = "操作人名称")
    @TableField(fill=FieldFill.INSERT_UPDATE)
    private String recUserName;

}
