package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
* 力量调派
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_power_transfer")
@ApiModel(value="PowerTransfer对象", description="力量调派")
public class PowerTransfer extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "警情id")
    private Long alertCalledId;

    @ApiModelProperty(value = "调派单号")
    private String dispatchNum;

    @ApiModelProperty(value = "调派类型")
    private String dispatchType;

    @ApiModelProperty(value = "发送者")
    private String taskSenderName;

    @ApiModelProperty(value = "发送者id")
    private Long taskSenderId;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "坐标x")
    private String coordinateX;

    @ApiModelProperty(value = "坐标y")
    private String coordinateY;

    @ApiModelProperty(value = "救援方格")
    private String rescueGrid;

    @ApiModelProperty(value = "车地址")
    private String carAddress;

    @ApiModelProperty(value = "车坐标x")
    private String carCoordinateX;

    @ApiModelProperty(value = "车坐标y")
    private String carCoordinateY;

    @TableField(value = "REC_USER_NAME", fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

}
