package com.yeejoin.amos.boot.module.jcs.api.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
* 机构/部门/人员表
*
* @author tb
* @date 2021-06-18
*/
@Data
@Accessors(chain = true)
@TableName("cb_org_usr")
@ApiModel(value="OrgUsrVo", description="人员信息")
public class OrgPersonFormVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "机构/部门id")
    private Long id;
    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ApiModelProperty(value = "机构类型`")
    private String bizOrgType;

    @ApiModelProperty(value = "所属建筑名称")
    private String buildName;

    @ApiModelProperty(value = "所属建筑ID")
    private String buildId;

    @ApiModelProperty(value = "归属机构/部门/人员")
    private String parentId;

    @ApiModelProperty(value = "动态表单值")
    private List<FormValue> dynamicFormAlert;

    public OrgPersonFormVo(String bizOrgName, String parentId, List<FormValue> dynamicFormAlert) {
        this.bizOrgName = bizOrgName;
        this.parentId = parentId;
        this.dynamicFormAlert = dynamicFormAlert;
    }

    public OrgPersonFormVo(Long id, String bizOrgName, String parentId, List<FormValue> dynamicFormAlert) {
        this.id = id;
        this.bizOrgName = bizOrgName;
        this.parentId = parentId;
        this.dynamicFormAlert = dynamicFormAlert;
    }

    public OrgPersonFormVo() {
    }
}
