package com.yeejoin.amos.boot.module.jcs.api.vo;

import java.io.Serializable;
import java.util.List;

import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
* 机构/部门/人员表
*
* @author tb
* @date 2021-06-18
*/
@Data
@Accessors(chain = true)
@ApiModel(value="OrgUsrVo", description="人员")
public class OrgPersonVo implements Serializable {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "人员基本信息")
    private  OrgUsr orgUsr;

    @ApiModelProperty(value = "动态表单值")
    private List<AlertFormValue> alertFormValue;

    public OrgPersonVo(OrgUsr orgUsr, List<AlertFormValue> alertFormValue) {
    	this.orgUsr = orgUsr;
        this.alertFormValue = alertFormValue;
    }
}
