package com.yeejoin.amos.boot.module.jcs.api.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
* 机构/部门/人员表
*
* @author tb
* @date 2021-06-18
*/
@Data
@Accessors(chain = true)
@TableName("cb_org_usr")
@ApiModel(value="OrgUsrVo", description="机构/部门/人员表")
public class OrgUsrFormVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "单位id")
    private Long id;

    @ApiModelProperty(value = "单位名称")
    private String currentUnit;

    @ApiModelProperty(value = "归属机构/部门")
    private String parentId;

    private Integer personNum;

    @ApiModelProperty(value = "动态表单值")
    private List<FormValue> dynamicFormAlert;

    @ApiModelProperty(value = "单位人员信息值")
    private List<OrgPersonFormVo> children;

    public OrgUsrFormVo(String currentUnit, String parentId, Integer personNum, List<FormValue> dynamicFormAlert, List<OrgPersonFormVo> children) {
        this.currentUnit = currentUnit;
        this.parentId = parentId;
        this.personNum = personNum;
        this.dynamicFormAlert = dynamicFormAlert;
        this.children = children;
    }

    public OrgUsrFormVo(Long id, String currentUnit, String parentId, Integer personNum,  List<FormValue> dynamicFormAlert, List<OrgPersonFormVo> children) {
        this.id = id;
        this.currentUnit = currentUnit;
        this.parentId = parentId;
        this.personNum = personNum;
        this.dynamicFormAlert = dynamicFormAlert;
        this.children = children;
    }

    public OrgUsrFormVo() {
    }
}
