package com.yeejoin.amos.boot.module.jcs.api.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 机构/部门/人员表
 *
 * @author tb
 * @date 2021-06-18
 */
@Data
@Accessors(chain = true)
@TableName("cb_org_usr")
@ApiModel(value = "OrgUsrVo", description = "单位信息")
public class OrgUsrVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "机构/部门名称")
    private String bizOrgName;

    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ApiModelProperty(value = "机构类型`")
    private String bizOrgType;

    @ApiModelProperty(value = "所属建筑名称")
    private String buildName;

    @ApiModelProperty(value = "所属建筑ID")
    private String buildId;

    @ApiModelProperty(value = "归属机构/部门/人员")
    private String parentId;

    @ApiModelProperty(value = "单位动态表单值")
    private List<AlertFormValue> alertFormValue;

    public OrgUsrVo(String bizOrgName, String bizOrgCode, String amosOrgId, String amosOrgCode, String bizOrgType, String buildName, String buildId, String parentId, List<AlertFormValue> alertFormValue) {
        this.bizOrgName = bizOrgName;
        this.bizOrgCode = bizOrgCode;
        this.amosOrgId = amosOrgId;
        this.amosOrgCode = amosOrgCode;
        this.bizOrgType = bizOrgType;
        this.buildName = buildName;
        this.buildId = buildId;
        this.parentId = parentId;
        this.alertFormValue = alertFormValue;
    }
}
