package com.yeejoin.amos.boot.module.tzs.api.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author tb
 * @date 2021-06-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tcb_use_unit")
@ApiModel(value = "UseUnitVo", description = "UseUnitVo")
public class UseUnitVo extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "统一社会信用代码")
    private String socialCreditCode;

    @ApiModelProperty(value = "使用单位（小区）名称")
    private String useUnitName;

    @ApiModelProperty(value = "小区所属地产品牌")
    private String realEstateBrand;

    @ApiModelProperty(value = "物业公司所属品牌")
    private String propertyCompanyBrand;

    @ApiModelProperty(value = "省份")
    private String province;

    @ApiModelProperty(value = "地市")
    private String city;

    @ApiModelProperty(value = "区县")
    private String district;

    @ApiModelProperty(value = "区域代码")
    private String regionCode;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "责任人id")
    private Long principalId;

    @ApiModelProperty(value = "主要负责人")
    private String principal;

    @ApiModelProperty(value = "负责人电话")
    private String principalPhone;

    @ApiModelProperty(value = "管理部门")
    private String management;

    @ApiModelProperty(value = "管理员id")
    private Long managerId;

    @ApiModelProperty(value = "电梯安全管理员")
    private String manager;

    @ApiModelProperty(value = "电梯管理员手机")
    private String managerPhone;

    @ApiModelProperty(value = "原始表id（来自历史数据库）")
    private String originalId;

}
