package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertSubmittedDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.*;
import com.yeejoin.amos.boot.module.jcs.api.enums.SubmissionMethodEnum;
import com.yeejoin.amos.boot.module.jcs.api.vo.*;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.HEAD;
import java.lang.reflect.Field;
import java.util.*;


/**
 * 警情报送记录
 *
 * @author tb
 * @date 2021-06-17
 */
@RestController
@Api(tags = "警情报送记录Api")
@RequestMapping(value = "/alert-submitted")
public class AlertSubmittedController extends BaseController {

    @Autowired
    AlertSubmittedServiceImpl alertSubmittedService;

    @Autowired
    TemplateServiceImpl templateService;

    @Autowired
    AlertCalledServiceImpl alertCalledService;

    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;

    @Autowired
    PowerTransferServiceImpl powerTransferService;

    /**
     * 新增警情报送记录
     *
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增警情报送记录", notes = "新增警情报送记录")

    public ResponseModel<Object> saveAlertSubmitted(HttpServletRequest request,
                                                    @RequestBody AlertSubmittedDto alertSubmittedDto) {
        return ResponseHelper.buildResponse(alertSubmittedService.save(alertSubmittedDto));

    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")

    public ResponseModel<Boolean> deleteById(HttpServletRequest request, @PathVariable Long id) {
        return ResponseHelper.buildResponse(alertSubmittedService.removeById(id));


    }

    /**
     * 修改警情报送记录
     *
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改警情报送记录", notes = "修改警情报送记录")

    public ResponseModel<Boolean> updateByIdAlertSubmitted(HttpServletRequest request,
                                                           @RequestBody AlertSubmitted alertSubmitted) {
        return ResponseHelper.buildResponse(alertSubmittedService.updateById(alertSubmitted));


    }

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<AlertSubmitted> selectById(HttpServletRequest request, @PathVariable Long id) {
        return ResponseHelper.buildResponse(alertSubmittedService.getById(id));

    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/scheduling/list", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "根据警情id查询融合调度列表", notes = "根据警情id查询融合调度列表")
    public ResponseModel<SchedulingReportingVo> listSchedulingByParam(@RequestBody AlertSubmittedDto queryParam) {
        return ResponseHelper.buildResponse(alertSubmittedService.listSchedulingByParam(queryParam));
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/reporting/list", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "根据警情id查询警情报送列表", notes = "根据警情id查询警情报送列表")

    public ResponseModel<SchedulingReportingVo> listReportingByParam(@RequestBody AlertSubmittedDto queryParam) {
        queryParam.setSubmissionMethodCode(SubmissionMethodEnum.PHONE.getCode());
        return ResponseHelper.buildResponse(alertSubmittedService.listReportingByParam(queryParam));
    }

    /**
     * 列表分页查询
     *
     * @return
     */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<AlertSubmitted> listPage(String pageNum, String pageSize, AlertSubmitted alertSubmitted) {

        Page<AlertSubmitted> pageBean;
        QueryWrapper<AlertSubmitted> alertSubmittedQueryWrapper = new QueryWrapper<>();
        Class<? extends AlertSubmitted> aClass = alertSubmitted.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            if (field.getName().equals("serialVersionUID")) {
                return;
            }
            try {
                field.setAccessible(true);
                Object o = field.get(alertSubmitted);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(alertSubmitted);
                        alertSubmittedQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class) || "long".equals(type.toString())) {
                        Long fileValue = (Long) field.get(alertSubmitted);
                        alertSubmittedQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(alertSubmitted);
                        alertSubmittedQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(alertSubmitted);
                        alertSubmittedQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw new RuntimeException("系统异常");
            }
        });
        IPage<AlertSubmitted> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = alertSubmittedService.page(pageBean, alertSubmittedQueryWrapper);
        return page;
    }

    /**
     * 获取警情续报内容
     *
     * @param alertCalledId 警情id
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{alertCalledId}/alert_submitted", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取警情续报内容和模板", notes = "获取警情续报内容和模板")
    public ResponseModel<Object> getAlertSubmittedContent(@PathVariable Long alertCalledId) {
        ArrayList<TemplateVo> templateVos = new ArrayList<>();
        try {
            // 获取警情详情
            String companyName = getSelectedOrgInfo().getCompany().getCompanyName();
            alertSubmittedService.getAlertSubmittedContent(alertCalledId, templateVos, companyName);
        } catch (IllegalAccessException e) {
            throw  new RuntimeException("系统异常");
        }
        return ResponseHelper.buildResponse(templateVos);
    }

    /**
     * 获取融合调度短信内容
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}/scheduling_content", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取融合调度短信内容", notes = "获取融合调度短信内容")
    public ResponseModel<AlertSubmittedSMSVo> getSchedulingContent(@PathVariable Long id) {
        // 获取报送内容
        AlertSubmittedSMSVo schedulingContent = alertSubmittedService.getSchedulingContent(id);
        return ResponseHelper.buildResponse(schedulingContent);
    }
}

