package com.yeejoin.amos.boot.module.jcs.biz.controller;

import java.util.Arrays;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.FireExperts;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.FireExpertsServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
* 
*
* @author tb
* @date 2021-06-07
*/
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/fire-experts")
public class FireExpertsController extends BaseController {

    @Autowired
    FireExpertsServiceImpl iFireExpertsService;

    /**
    * 新增
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveFireExperts(HttpServletRequest request, @RequestBody FireExperts fireExperts){
        return iFireExpertsService.save(fireExperts);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
        return iFireExpertsService.removeById(id);
    }




    /**
    * 修改
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdFireExperts(HttpServletRequest request, @RequestBody FireExperts fireExperts){
        return iFireExpertsService.updateById(fireExperts);
    }



    /**
    * 根据id查询
    * @param id
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public FireExperts selectById(HttpServletRequest request, @PathVariable Long id){
        return iFireExpertsService.getById(id);
    }



    /**
    * 列表分页查询
    * @return
    */
    @TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<FireExperts> listPage(String pageNum,String pageSize, FireExperts fireExperts){

        Page<FireExperts> pageBean;
        QueryWrapper<FireExperts> fireExpertsQueryWrapper = new QueryWrapper<>();
        Class<? extends FireExperts> aClass = fireExperts.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(fireExperts);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(fireExperts);
                        fireExpertsQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(fireExperts);
                        fireExpertsQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(fireExperts);
                        fireExpertsQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(fireExperts);
                        fireExpertsQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw  new RuntimeException("系统异常");
            }
        });
        IPage<FireExperts> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iFireExpertsService.page(pageBean, fireExpertsQueryWrapper);
            return page;
        }
    }

