package com.yeejoin.amos.boot.module.jcs.biz.controller;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.biz.common.utils.ExcelUtils;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.jcs.api.vo.FormValue;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgPersonFormVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgPersonVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgUsrDownloadTemplateVO;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.AlertFormValueServiceImpl;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.OrgUsrServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;



/**
 * @author fengwang
 * @date 2021-06-21.
 */
@RestController
@Api(tags = "人员表Api")
@RequestMapping(value = "/org-person")
public class OrgPersonController {
    @Autowired
    OrgUsrServiceImpl iOrgUsrService;
    @Autowired
    AlertFormValueServiceImpl iAlertFromValueService;

    /**
     * 新增人员信息
     *
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增人员信息", notes = "新增人员信息")
    public ResponseModel saveOrgUsr(HttpServletRequest request, @RequestBody OrgPersonVo OrgPersonVo) {
        OrgUsr orgUsr = OrgPersonVo.getOrgUsr();
        // 单位新增情况
        iOrgUsrService.save(orgUsr);
        // 动态表单
        List<AlertFormValue> alertFromValuelist = OrgPersonVo.getAlertFormValue();
        // 填充主键
        alertFromValuelist.stream().forEach(alertFromValue -> {
            alertFromValue.setAlertCalledId(orgUsr.getSequenceNbr());
        });
        // 保存动态表单数据
        iAlertFromValueService.saveBatch(alertFromValuelist);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public ResponseModel deleteById(HttpServletRequest request, @PathVariable Long id) {
        // 删除时，只作逻辑删除
        iOrgUsrService.update(new UpdateWrapper<OrgUsr>().eq("sequence_nbr", id).set("is_delete", CommonConstant.IS_DELETE_01));
        return ResponseHelper.buildResponse(null);
    }


    /**
     * 更新人员数据
     *
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "更新单位数据", notes = "更新单位数据")
    public ResponseModel updateByIdOrgUsr(HttpServletRequest request, @RequestBody OrgUsr orgUsr, @PathVariable Long id) {
        // 修改单位信息
        iOrgUsrService.updateById(orgUsr);
        return ResponseHelper.buildResponse(null);
    }


    /**
     * 根据id查询人员
     *
     * @param id
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取人员详情", notes = "获取人员详情")
    public ResponseModel selectById(HttpServletRequest request, @PathVariable Long id) {
        OrgUsr orgUsr = iOrgUsrService.getById(id);
        QueryWrapper queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("alert_called_id", id);
        // 动态表单数据
        List<AlertFormValue> list = iAlertFromValueService.list(queryWrapper);
        List<FormValue> formValue = new ArrayList();
        for (AlertFormValue alertFormValue : list) {
            FormValue value = new FormValue(alertFormValue.getFieldCode(), alertFormValue.getFieldName(), "text", alertFormValue.getFieldValue(),alertFormValue.isBlock());
            formValue.add(value);
        }
        OrgPersonFormVo orgUsrFormVo = new OrgPersonFormVo();
        BeanUtils.copyProperties(orgUsr,orgUsrFormVo);
        orgUsrFormVo.setDynamicFormAlert(formValue);
        return ResponseHelper.buildResponse(orgUsrFormVo);
    }


    /**
     * 根据bizOrgType分页查询
     *
     * @param bizOrgType
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/selectByBizOrgType/{bizOrgType}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据bizOrgType分页查询", notes = "根据bizOrgType分页查询")
    public ResponseModel bizOrgTypeListPage(String pageNum, String pageSize, @PathVariable String bizOrgType) {
        Page<OrgUsr> pageBean = new Page<>();
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        return ResponseHelper.buildResponse(iOrgUsrService.page(pageBean, new QueryWrapper<OrgUsr>().eq("biz_org_type", bizOrgType)));
    }


    /**
     * 获取人员树
     *
     * @param
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/companyTree", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取人员树", notes = "获取人员树")
    public ResponseModel selectCompanyTree() throws Exception {
        Map<String, Object> columnMap = new HashMap<>();
        columnMap.put("is_delete", CommonConstant.IS_DELETE_00);
        columnMap.put("biz_org_type", CommonConstant.BIZ_ORG_TYPE_PERSON);
        Collection<OrgUsr> list = iOrgUsrService.listByMap(columnMap);
        return ResponseHelper.buildResponse(iOrgUsrService.getTree(null, list, OrgUsr.class.getName(), "getSequenceNbr", 2, "getBizOrgName", "getParentId", "getBizOrgType"));
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public ResponseModel<Object> listPage(String pageNum, String pageSize, OrgUsr orgUsr) {

        Page<OrgUsr> pageBean;
        QueryWrapper<OrgUsr> orgUsrQueryWrapper = new QueryWrapper<>();
        Class<? extends OrgUsr> aClass = orgUsr.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(orgUsr);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(orgUsr);
                        orgUsrQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<OrgUsr> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iOrgUsrService.page(pageBean, orgUsrQueryWrapper);
        return  ResponseHelper.buildResponse(page);
    }

    /**
     *
     *
     * @param orgCode
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{orgCode}/users", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据orgCode查询", notes = "根据orgCode查询")
    public ResponseModel selectUsersByOrgCode(HttpServletRequest request, String pageNum, String pageSize, @PathVariable Long orgCode) {
        Map<String, Object> columnMap = new HashMap<>();
        columnMap.put("is_delete",CommonConstant.IS_DELETE_00);
        columnMap.put("biz_org_code", orgCode);
        columnMap.put("biz_org_type", CommonConstant.BIZ_ORG_TYPE_PERSON);
        iOrgUsrService.listByMap(columnMap);
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 导出人员模板
     *
     * @param response
     * @param OrgUsrDownloadTemplateVO
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "download-template", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "导出人员模板", notes = "导出人员模板")
    public ResponseModel downloadTemplate(HttpServletResponse response, @RequestBody List<OrgUsrDownloadTemplateVO> OrgUsrDownloadTemplateVO) throws UnsupportedEncodingException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        ExcelUtils.exportExcel(OrgUsrDownloadTemplateVO, "人员信息", "人员信息", OrgUsrDownloadTemplateVO.class, simpleDateFormat.format(new Date()) + ".xls", response);
        return ResponseHelper.buildResponse(null);
    }
}
