package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.mapper.AlertCalledMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertCalledService;
import com.yeejoin.amos.boot.module.jcs.api.vo.AlertCalledVo;

/**
* 警情接警记录 服务实现类
*
* @author tb
* @date 2021-06-17
*/
@Service
public class AlertCalledServiceImpl extends BaseService<AlertCalledDto,AlertCalled,AlertCalledMapper> implements IAlertCalledService {

	 @Autowired
	 RedisUtils redisUtils;
	 @Autowired
	 AlertCalledMapper alertCalledMapper;
	 
	@Autowired
	private AlertFormValueServiceImpl iAlertFormValueService;
	    
//    @Autowired
//    private ESAlertCalledService eSAlertCalledService;
	    
	/**
	 * 
	 * <pre>
	 * 保存警情信息
	 * </pre>
	 *
	 * @param alertCalledVo
	 * @return
	 */
	 public AlertCalledVo createAlertCalled(AlertCalledVo alertCalledVo) throws Exception 
	 {
   	  // 警情基本信息
         AlertCalled alertCalled = alertCalledVo.getAlertCalled();
         // 判断是否归并警情
         if (alertCalled.getFatherAlert() != null) {
             // 警情归并，设置当前警情状态为结束。
             alertCalled.setAlertStatus(true);
         } else {
             // 警情报送
             // ****************************************************待确认开发
         }
         this.save(alertCalled);
         // 动态表单
         List<AlertFormValue> alertFormValuelist = alertCalledVo.getAlertFormValue();
         // 填充警情主键
         alertFormValuelist.stream().forEach(alertFormValue -> {
             alertFormValue.setAlertCalledId(alertCalled.getSequenceNbr());
             alertFormValue.setAlertTypeCode(alertCalled.getAlertTypeCode());
         });
         // 保存动态表单数据
         iAlertFormValueService.saveBatch(alertFormValuelist);
         
         /**
          * 同步保存ES
          */
//         eSAlertCalledService.saveAlertCalledToES(alertCalled);
         
		 return alertCalledVo;
	 }
		 
		 
	 /*
	  * 根据id 修改警情
	  * type：警情相关 操作类型  0警情续报   1非警情确认   2 警情结案
	  * */
	@Override
	public boolean updateAlertCalled(Long id, String code,String name) {
		// TODO Auto-generated method stub
		switch (code) {
		case "314":
			alertCalledMapper.update(null, new UpdateWrapper<AlertCalled>().eq("sequence_nbr", id)
					.set("alert_status", 1).set("alert_stage", "").set("alarm_type", name).set("alarm_type_code", code) );  
			break;
        case "315":
			
			break;
		default:
			break;
		}	
		 //删除缓存
        redisUtils.del(RedisKey.ALERTCALLED_ID+id);
		return false;
	}

	
	
}
