package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertFromDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertForm;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.DataDictionary;
import com.yeejoin.amos.boot.module.jcs.api.mapper.AlertFormMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertFormService;
import com.yeejoin.amos.boot.module.jcs.api.vo.AlertFormVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.AlertListvalue;
import com.yeejoin.amos.boot.module.jcs.api.vo.Items;

/**
* 警情表单 服务实现类
*
* @author tb
* @date 2021-06-17
*/
@Service
public class AlertFormServiceImpl extends BaseService<AlertFromDto,AlertForm,AlertFormMapper> implements IAlertFormService{
	@Autowired
	DataDictionaryServiceImpl iDataDictionaryService;
	
	public List<AlertFormVo> getFormlist(String code) {

		 QueryWrapper<AlertForm> queryWrapper = new QueryWrapper<>();
         queryWrapper.eq("alert_type_code", code);
         List<AlertForm>  alertFormValue = this.list(queryWrapper);
		List<AlertFormVo> listfrom = new ArrayList<AlertFormVo>();
		// 组装数据
		for (AlertForm alertFrom : alertFormValue) {
			if(alertFrom.getFieldType().equals("string")||alertFrom.getFieldType().equals("date")||alertFrom.getFieldType().equals("textarea")) {				
				AlertFormVo vo = new AlertFormVo(alertFrom.getFieldCode(), alertFrom.getFieldName(), alertFrom.getFieldType(), null,
						new AlertFormValue(alertFrom.getSequenceNbr(),alertFrom.getFieldName(), alertFrom.getFieldCode(),alertFrom.isBlock()));
				listfrom.add(vo);				
			}else {
				// 查询数据项
				Map<String, Object> columnMap = new HashMap<>();
				columnMap.put("type", alertFrom.getFieldValueCode());
				Collection<DataDictionary> listDataDictionary = iDataDictionaryService.listByMap(columnMap);
				AlertFormVo vo = new AlertFormVo(alertFrom.getFieldCode(), alertFrom.getFieldName(), alertFrom.getFieldType(), 
				new Items(getdata(listDataDictionary)), new AlertFormValue(alertFrom.getSequenceNbr(),alertFrom.getFieldName(), alertFrom.getFieldCode(),alertFrom.isBlock()));
				listfrom.add(vo);				
			}
		}

		return listfrom;
	}

	public List<AlertListvalue> getdata(Collection<DataDictionary> list) {
		List<AlertListvalue> listAlertListvalue = new ArrayList<AlertListvalue>();
		for (DataDictionary dataDictionary : list) {

			listAlertListvalue.add(new AlertListvalue(dataDictionary.getSequenceNbr().toString(),
					 dataDictionary.getName(),dataDictionary.getCode()));
		}
		return listAlertListvalue;
	}
}
