package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.utils.EnumsUtils;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertSubmittedDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.*;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertBusinessTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertSchedulingTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.AlertSubmitTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.SubmissionMethodEnum;
import com.yeejoin.amos.boot.module.jcs.api.mapper.AlertSubmittedMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertSubmittedObjectService;
import com.yeejoin.amos.boot.module.jcs.api.service.IAlertSubmittedService;
import com.yeejoin.amos.boot.module.jcs.api.vo.*;
import org.springframework.beans.BeanUtils;
import com.yeejoin.amos.boot.module.jcs.api.vo.AlertSubmittedExtVo;
import com.yeejoin.amos.boot.module.jcs.api.vo.SchedulingReportingVo;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.*;
import java.util.stream.Collectors;

/**
* 警情报送记录 服务实现类
*
* @author tb
* @date 2021-06-17
*/
@Service
public class AlertSubmittedServiceImpl extends BaseService<AlertSubmittedDto,AlertSubmitted,AlertSubmittedMapper> implements IAlertSubmittedService {

    @Autowired
    IAlertSubmittedObjectService iAlertSubmittedObjectService;
    @Autowired
    AlertSubmittedObjectServiceImpl alertSubmittedObjectServiceImpl;
    @Autowired
    AlertCalledServiceImpl alertCalledService;
    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;
    @Autowired
    TemplateServiceImpl templateService;
    @Autowired
    PowerTransferServiceImpl powerTransferService;

    @Override
    public SchedulingReportingVo listSchedulingByParam(AlertSubmittedDto queryParam) {
        SchedulingReportingVo schedulingReportingVo = new SchedulingReportingVo();
        List<AlertSubmittedExtVo> alertSubmittedExtVoList = this.baseMapper.listSchedulingByParam(queryParam);
        schedulingReportingVo.setSchedulingReportingList(alertSubmittedExtVoList);
        Map<String, List<AlertSubmittedExtVo>> groupMap =
                alertSubmittedExtVoList.stream().collect(Collectors.groupingBy(AlertSubmittedExtVo::getSubmissionMethodCode));
        int phoneSize = 0;
        int smsSize = 0;
        if (ObjectUtils.isNotEmpty(groupMap.get(SubmissionMethodEnum.PHONE.getCode()))) {
            phoneSize = groupMap.get(SubmissionMethodEnum.PHONE.getCode()).size();
        }
        if (ObjectUtils.isNotEmpty(groupMap.get(SubmissionMethodEnum.SMS.getCode()))) {
            smsSize = groupMap.get(SubmissionMethodEnum.SMS.getCode()).size();
        }
        String extraInfo = String.format("已调度电话%s起，短信%d批", phoneSize, smsSize);
        schedulingReportingVo.setExtraInfo(extraInfo);
        return schedulingReportingVo;
    }

    @Override
    public SchedulingReportingVo listReportingByParam(AlertSubmittedDto queryParam) {
        SchedulingReportingVo schedulingReportingVo = new SchedulingReportingVo();
        List<AlertSubmittedExtVo> alertSubmittedExtVoList = this.baseMapper.listReportingByParam(queryParam);
        schedulingReportingVo.setSchedulingReportingList(alertSubmittedExtVoList);
        // TODO 填充短信报送内容

        String extraInfo = String.format("已报送%d条", alertSubmittedExtVoList.size());
        schedulingReportingVo.setExtraInfo(extraInfo);
        return schedulingReportingVo;
    }

    @Override
    public Boolean save(AlertSubmittedDto alertSubmittedDto) {
        // 1.保存警情记录主表
        AlertSubmitted alertSubmitted = new AlertSubmitted();
        alertSubmitted.setAlertCalledId(alertSubmittedDto.getAlertCalledId());
        alertSubmitted.setBusinessTypeCode(alertSubmittedDto.getBusinessTypeCode());
        Optional<AlertBusinessTypeEnum> businessTypeEnum = EnumsUtils.getEnumObject(AlertBusinessTypeEnum.class,
                e -> e.getCode().equals(alertSubmittedDto.getBusinessTypeCode()));
        alertSubmitted.setBusinessType(businessTypeEnum.orElse(AlertBusinessTypeEnum.警情续报).getName());
        alertSubmitted.setCallLogId(alertSubmittedDto.getCallLogId());
        alertSubmitted.setSubmissionMethodCode(alertSubmittedDto.getSubmissionMethodCode());
        Optional<SubmissionMethodEnum> submissionMethodEnum = EnumsUtils.getEnumObject(SubmissionMethodEnum.class,
                e -> e.getCode().equals(alertSubmittedDto.getBusinessTypeCode()));
        alertSubmitted.setSubmissionMethod(submissionMethodEnum.orElse(SubmissionMethodEnum.SMS).getName());
        Optional<AlertSchedulingTypeEnum> alertSchedulingTypeEnum = EnumsUtils.getEnumObject(AlertSchedulingTypeEnum.class,
                e -> e.getCode().equals(alertSubmittedDto.getBusinessTypeCode()));
        alertSubmitted.setSchedulingTypeCode(alertSubmittedDto.getSchedulingTypeCode());
        alertSubmitted.setSchedulingType(alertSchedulingTypeEnum.orElse(AlertSchedulingTypeEnum.融合调度).getName());
        alertSubmitted.setSubmissionContent(alertSubmittedDto.getSubmitContent().toJSONString());

        this.baseMapper.insert(alertSubmitted);

        // 2.保存任务表
        List<AlertSubmittedObject> alertSubmittedObjectList = Lists.newArrayList();
        // 报送给单位
        if (AlertSubmitTypeEnum.Org.getKey().equals(alertSubmittedDto.getType())) {
            alertSubmittedDto.getSubmitCompanyList().forEach(company -> {
                AlertSubmittedObject alertSubmittedObject = new AlertSubmittedObject();
                alertSubmittedObject.setAlertSubmittedId(alertSubmitted.getSequenceNbr());
                alertSubmittedObject.setType(true);
                alertSubmittedObject.setCompanyId(company.getCompanyId());
                alertSubmittedObject.setCompanyName(company.getCompanyName());

                alertSubmittedObjectList.add(alertSubmittedObject);
            });
        } else {
            // 报送给个人
            alertSubmittedDto.getSubmitCompanyList().forEach(company -> {
                company.getPersonList().forEach(person -> {
                    AlertSubmittedObject alertSubmittedObject = new AlertSubmittedObject();
                    alertSubmittedObject.setAlertSubmittedId(alertSubmitted.getSequenceNbr());
                    alertSubmittedObject.setType(false);
                    alertSubmittedObject.setCompanyId(company.getCompanyId());
                    alertSubmittedObject.setCompanyName(company.getCompanyName());
                    alertSubmittedObject.setUserId(person.getPersonId());
                    alertSubmittedObject.setUserName(person.getPersonName());
                    alertSubmittedObject.setUserPhone(person.getPersonPhone());

                    alertSubmittedObjectList.add(alertSubmittedObject);
                });
            });
        }

        alertSubmittedObjectServiceImpl.saveBatch(alertSubmittedObjectList);
        // 3.发送任务消息
        // 调用平台短信发送接口发送消息
        return true;
    }

    public void getAlertSubmittedContent(Long alertCalledId, ArrayList<TemplateVo> templateVos, String companyName) throws IllegalAccessException {
        AlertCalled alertCalled = alertCalledService.getById(alertCalledId);
        Map<String, Object> map = objectToMap(alertCalled);
        map.put("companyName", companyName);

        // 获取模板内容
        List<DataDictionary> dataDictionaries =
                dataDictionaryService.list(new QueryWrapper<DataDictionary>().eq("type",
                        "JQBSLX"));
        for (DataDictionary dataDictionary : dataDictionaries) {
            Template template = templateService.getOne(new QueryWrapper<Template>().eq("type_code",
                    dataDictionary.getCode()));
            List<PowerTransferCompanyVo> lastPowerTransferCompany;
            powerTransferService.getLastPowerTransferCompany(alertCalledId);
            if ("警情续报".equals(template.getType()) && (lastPowerTransferCompany =
                    powerTransferService.getLastPowerTransferCompany(alertCalledId)).size() > 0) {
                // 获取力量调派内容
                StringBuilder companyNames = new StringBuilder();
                StringBuilder resourcesInfo = new StringBuilder();
                for (PowerTransferCompanyVo powerTransferCompanyVo : lastPowerTransferCompany) {
                    companyNames.append(powerTransferCompanyVo.getCompanyName()).append("、");
                    resourcesInfo.append(powerTransferCompanyVo.getType()).append(powerTransferCompanyVo.getResourcesCount()).append("辆、");
                }
                map.put("companyNames", companyNames.deleteCharAt(companyNames.length() - 1).toString());
                map.put("resourcesInfo", resourcesInfo.deleteCharAt(resourcesInfo.length() - 1).toString());
            }
            TemplateVo templateVo = new TemplateVo();
            BeanUtils.copyProperties(template, templateVo);
            templateVo.setData(map);
            templateVos.add(templateVo);
        }
    }

    /**
     * 将Object对象里面的属性和值转化成Map对象
     *
     * @param obj 源对象
     * @return 转化结果
     * @throws IllegalAccessException IllegalAccessException
     */
    @SuppressWarnings("unchecked")
    public static Map<String, Object> objectToMap(Object obj) throws IllegalAccessException {
        Map<String, Object> map = new HashMap<>();
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();

        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if ("dynamicFormAlert".equalsIgnoreCase(fieldName)) {
                List<FormValue> dynamicFormAlert = (List<FormValue>) field.get(obj);
                for (FormValue formValue : dynamicFormAlert) {
                    map.put(formValue.getLabel(), formValue.getValue());
                }
            } else {
                Object value = field.get(obj);
                map.put(fieldName, value);
            }
        }
        return map;
    }

    @Override
    public AlertSubmittedSMSVo getSchedulingContent(Long id) {
        return this.baseMapper.getSchedulingContent(id);
    }
}
