package com.yeejoin.amos.boot.module.jcs.biz.service.impl;


import com.yeejoin.amos.boot.module.jcs.api.dto.OrgUsrDto;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.jcs.api.mapper.OrgUsrMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.jcs.api.vo.OrgMenuVo;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;


import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 机构/部门/人员表 服务实现类
 *
 * @author tb
 * @date 2021-06-18
 */

@Service
public class OrgUsrServiceImpl extends  BaseService<OrgUsrDto,OrgUsr,OrgUsrMapper>  implements IOrgUsrService {
    @Autowired
    AlertFormValueServiceImpl alertFormValueServiceImpl;

    @Override
    public String selectUpUnitByParam(String biz_org_code) {
        return this.baseMapper.selectUpUnitByParam(biz_org_code);
    }
    @Override
    @SuppressWarnings("unchecked")
    public List<OrgMenuVo> getTree(Long topId, Collection entityList, String packageURL, String IDMethodName, int IDHierarchy, String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception {
        List<OrgMenuVo> resultList = new ArrayList<>();
        Class clazz = Class.forName(packageURL);
        Method IDMethodNameme = null;
        switch (IDHierarchy) {
            case 1:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
            case 2:
                IDMethodNameme = clazz.getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            case 3:
                IDMethodNameme = clazz.getSuperclass().getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            default:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
        }

        Method NAMEMethodNameme = clazz.getDeclaredMethod(NAMEMethodName);
        Method PARENTIDMethodNameme = clazz.getDeclaredMethod(PARENTIDMethodName);
        Method OrgTypeMethodNameme = clazz.getDeclaredMethod(OrgTypeMethodName);
        //获取顶层元素集合
        Long parentId;
        for (Object ob : entityList) {

            Object entity = clazz.cast(ob);

            parentId = PARENTIDMethodNameme.invoke(entity) != null ? Long.valueOf(String.valueOf(PARENTIDMethodNameme.invoke(entity))) : null;

            if (parentId == null || topId == parentId) {
                OrgMenuVo menu = new OrgMenuVo(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId, String.valueOf(OrgTypeMethodNameme.invoke(entity)), false);
                resultList.add(menu);
            }
        }
        //获取每个顶层元素的子数据集合
        for (OrgMenuVo entity : resultList) {
            entity.setChildren(getSub(entity.getKey(), entityList, packageURL, IDMethodName, IDHierarchy, NAMEMethodName, PARENTIDMethodName, OrgTypeMethodName));
        }

        return resultList;
    }

    @SuppressWarnings("unchecked")
	@Override
    public List<OrgMenuVo> getSub(Long topId, @SuppressWarnings("rawtypes") Collection entityList, String packageURL, String IDMethodName, int IDHierarchy, String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception{
        List<OrgMenuVo> childList=new ArrayList<>();
        @SuppressWarnings("rawtypes")
		Class clazz=  Class.forName(packageURL);

        Method IDMethodNameme = null;
        switch (IDHierarchy) {
            case 1:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
            case 2:
                IDMethodNameme = clazz.getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            case 3:
                IDMethodNameme = clazz.getSuperclass().getSuperclass().getDeclaredMethod(IDMethodName);
                break;
            default:
                IDMethodNameme = clazz.getDeclaredMethod(IDMethodName);
                break;
        }
        Method OrgTypeMethodNameme = clazz.getDeclaredMethod(OrgTypeMethodName);
        Method NAMEMethodNameme = clazz.getDeclaredMethod(NAMEMethodName);
        Method PARENTIDMethodNameme = clazz.getDeclaredMethod(PARENTIDMethodName);

        Long parentId;
        //子集的直接子对象
        for (Object ob : entityList) {
            Object entity = clazz.cast(ob);

            parentId = PARENTIDMethodNameme.invoke(entity) != null ? Long.valueOf(String.valueOf(PARENTIDMethodNameme.invoke(entity))) : null;

            if (parentId == null) {
                if (topId == parentId) {
                    OrgMenuVo menu = new OrgMenuVo(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId, String.valueOf(OrgTypeMethodNameme.invoke(entity)), false);
                    childList.add(menu);
                }
            } else {
                if (topId.longValue() == parentId.longValue()) {
                    OrgMenuVo menu = new OrgMenuVo(Long.valueOf(String.valueOf(IDMethodNameme.invoke(entity))), String.valueOf(NAMEMethodNameme.invoke(entity)), parentId, String.valueOf(OrgTypeMethodNameme.invoke(entity)), true);
                    childList.add(menu);
                }
            }

        }

        //子集的间接子对象
        for (OrgMenuVo entity : childList) {
            entity.setChildren(getSub(entity.getKey(), entityList, packageURL, IDMethodName, IDHierarchy, NAMEMethodName, PARENTIDMethodName, OrgTypeMethodName));
        }

        //递归退出条件
        if (childList.size() == 0) {
            return null;
        }

        return childList;
    }

    @Override
    public List<Map<String, Object>> returnCompanyPersonMsg(List<Long> ids) throws Exception {
        List<Map<String, Object>> companyPersonMsg = new ArrayList<>();
        for (int i = 0; i < ids.size(); i++) {
            Map<String, Object> columnMap = new HashMap<>();
            Map<String, Object> resultMap = new HashMap<>();
            // 查询出单位基本信息
            OrgUsr company = getById(ids.get(i));
            resultMap.put("id", company.getSequenceNbr());
            resultMap.put("upUnit", selectUpUnitByParam(company.getBizOrgCode()));
            resultMap.put("currentUnit", company.getBizOrgName());
            // 人员数量
            Map<String, Object> countPerson = new HashMap<>();
            countPerson.put("parent_id", company.getSequenceNbr());
            countPerson.put("biz_org_type",CommonConstant.BIZ_ORG_TYPE_PERSON);
            QueryWrapper personNumWrapper = new QueryWrapper<Integer>();
            personNumWrapper.allEq(countPerson);
            resultMap.put("personNum", count(personNumWrapper));
            QueryWrapper companyWrapper = new QueryWrapper<AlertFormValue>();
            companyWrapper.eq("alert_called_id",company.getSequenceNbr());
            List<Map<String, Object>> personList = new ArrayList<>();
            if(alertFormValueServiceImpl.list(companyWrapper).size() != 0){
                // 查询动态表单Phone
                Map<String, Object> phone = new HashMap<>();
                phone.put("alert_called_id", company.getSequenceNbr());
                phone.put("field_code", "companyPhone");
                QueryWrapper phoneWrapper = new QueryWrapper<AlertFormValue>();
                phoneWrapper.allEq(phone);
                AlertFormValue phoneValue = alertFormValueServiceImpl.getOne(phoneWrapper);
                resultMap.put("tel", phoneValue.getFieldValue());
                // 获取单位人员列表信息
                Map<String, Object> personColumnMap = new HashMap<>();
                personColumnMap.put("is_delete", CommonConstant.IS_DELETE_00);
                personColumnMap.put("biz_org_code", company.getBizOrgCode());
                personColumnMap.put("biz_org_type", CommonConstant.BIZ_ORG_TYPE_PERSON);
                Collection<OrgUsr> orgUsrs = listByMap(personColumnMap);
                orgUsrs.forEach(orgUsr -> {
                    Map<String, Object> personMap = new HashMap<>();
                    personMap.put("id", orgUsr.getSequenceNbr());
                    personMap.put("name", orgUsr.getBizOrgName());
                    personMap.put("unit",company.getBizOrgName());
                    QueryWrapper wrapper = new QueryWrapper<AlertFormValue>();
                    wrapper.eq("alert_called_id",orgUsr.getSequenceNbr());
                    if ( alertFormValueServiceImpl.list(wrapper).size() == 0 ){
                        personMap.put("zhiweii",null);
                        personMap.put("tel", null);
                        personMap.put("img", null);
                        personList.add(personMap);
                    }else{
                        // 查询动态表单zhiwei
                        Map<String, Object> zhiwei = new HashMap<String, Object>();
                        zhiwei.put("alert_called_id", orgUsr.getSequenceNbr());
                        zhiwei.put("field_code", "internalPosition");
                        QueryWrapper zhiweiWrapper = new QueryWrapper<AlertFormValue>();
                        zhiweiWrapper.allEq(zhiwei);
                        AlertFormValue zhiweiValue = alertFormValueServiceImpl.getOne(zhiweiWrapper);
                        personMap.put("zhiwu", zhiweiValue.getFieldValue());
                        // 查询动态表单Phone
                        Map<String, Object> personPhone = new HashMap<String, Object>();
                        personPhone.put("alert_called_id", orgUsr.getSequenceNbr());
                        personPhone.put("field_code", "telephone");
                        QueryWrapper personPhoneWrapper = new QueryWrapper<AlertFormValue>();
                        personPhoneWrapper.allEq(personPhone);
                        AlertFormValue personPhoneValue = alertFormValueServiceImpl.getOne(personPhoneWrapper);
                        personMap.put("tel", personPhoneValue.getFieldValue());
                        // 查询动态表单Img
                        Map<String, Object> img = new HashMap<String, Object>();
                        img.put("alert_called_id", orgUsr.getSequenceNbr());
                        img.put("field_code", "personImg");
                        QueryWrapper imgWrapper = new QueryWrapper<AlertFormValue>();
                        imgWrapper.allEq(img);
                        AlertFormValue imgValue = alertFormValueServiceImpl.getOne(imgWrapper);
                        personMap.put("img", imgValue.getFieldValue());
                        personList.add(personMap);
                    }
                });
            }
            resultMap.put("children",personList);
            companyPersonMsg.add(resultMap);
        }
        return companyPersonMsg;
    }


}
