package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.tzs.api.dto.RescueStationDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.RescueStation;
import com.yeejoin.amos.boot.module.tzs.api.service.IRescueStationService;
import com.yeejoin.amos.boot.module.tzs.api.vo.RescueStationVo;
import com.yeejoin.amos.boot.module.tzs.biz.utils.BeanDtoVoUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Arrays;
import java.util.Date;


/**
 * 救援站
 *
 * @author tb
 * @date 2021-06-01
 */
@RestController
@Api(tags = "救援站Api")
@RequestMapping(value = "/tzs/rescue-station")
public class RescueStationController extends BaseController {

    private final Logger logger = LoggerFactory.getLogger(RescueStationController.class);

    @Autowired
    IRescueStationService iRescueStationService;

    /**
     * 新增救援站
     *
     * @param rescueStationDto 救援站
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增救援站", notes = "新增救援站")
    public ResponseModel<Boolean> saveRescueStation(@RequestBody RescueStationDto rescueStationDto) {
        RescueStation rescueStation = BeanDtoVoUtils.convert(rescueStationDto, RescueStation.class);
        rescueStation.setRecUserId(getUserId());
        rescueStation.setRecDate(new Date());
        boolean save = iRescueStationService.save(rescueStation);
        return ResponseHelper.buildResponse(save);
    }

    /**
     * 根据id删除
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public ResponseModel<Boolean> deleteById(@PathVariable Long id) {
        RescueStation rescueStation = iRescueStationService.getById(id);
        rescueStation.setIsDelete(true);
        rescueStation.setRecUserId(getUserId());
        rescueStation.setRecDate(new Date());
        boolean remove = iRescueStationService.updateById(rescueStation);
        return ResponseHelper.buildResponse(remove);
    }

    /**
     * 修改救援站
     *
     * @param rescueStationDto 救援站
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改救援站", notes = "修改救援站")
    public ResponseModel<Boolean> updateByIdRescueStation(@RequestBody RescueStationDto rescueStationDto) {

        RescueStation rescueStation = BeanDtoVoUtils.convert(rescueStationDto, RescueStation.class);
        rescueStation.setRecUserId(getUserId());
        rescueStation.setRecDate(new Date());
        boolean update = iRescueStationService.updateById(rescueStation);
        return ResponseHelper.buildResponse(update);
    }

    /**
     * 根据id查询
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<RescueStationVo> selectById(@PathVariable Long id) {
        RescueStation rescueStation = iRescueStationService.getById(id);
        RescueStationVo rescueStationVo = BeanDtoVoUtils.convert(rescueStation, RescueStationVo.class);
        return ResponseHelper.buildResponse(rescueStationVo);
    }

    /**
     * 列表分页查询
     *
     * @param pageNum          页码
     * @param pageSize         每页大小
     * @param rescueStationDto 查询参数
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public ResponseModel<IPage<RescueStationVo>> listPage(String pageNum, String pageSize,
                                                          RescueStationDto rescueStationDto) {
        RescueStation rescueStation = BeanDtoVoUtils.convert(rescueStationDto, RescueStation.class);
        Page<RescueStation> pageBean;
        QueryWrapper<RescueStation> rescueStationQueryWrapper = new QueryWrapper<>();
        Class<? extends RescueStation> aClass = rescueStation.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(rescueStation);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(rescueStation);
                        rescueStationQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(rescueStation);
                        rescueStationQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(rescueStation);
                        rescueStationQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(rescueStation);
                        rescueStationQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
        IPage<RescueStation> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iRescueStationService.page(pageBean, rescueStationQueryWrapper);
        IPage<RescueStationVo> rescueStationVoIPage = BeanDtoVoUtils.iPageVoStream(page, RescueStationVo.class);
        return ResponseHelper.buildResponse(rescueStationVoIPage);
    }

    /**
     * 分页查询救援站信息
     *
     * @param pageNum          页码
     * @param pageSize         每页大小
     * @param rescueStationDto 查询参数
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/query_rescue_station_list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "分页查询救援站信息", notes = "分页查询救援站信息")
    public ResponseModel<IPage<RescueStationVo>> queryRescueStationList(String pageNum, String pageSize,
                                                                        RescueStationDto rescueStationDto) {
        RescueStation rescueStation = BeanDtoVoUtils.convert(rescueStationDto, RescueStation.class);
        Page<RescueStation> pageBean;
        QueryWrapper<RescueStation> rescueStationQueryWrapper = new QueryWrapper<>();
        Class<? extends RescueStation> aClass = rescueStation.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(rescueStation);
                if (o != null) {
                    String name = NameUtils.camel2Underline(field.getName());
                    if ("name".equalsIgnoreCase(name) || "address".equalsIgnoreCase(name) || "principal".equalsIgnoreCase(name) || "rescue_leader".equalsIgnoreCase(name) || "rescue_leader_phone".equalsIgnoreCase(name)) {
                        String fileValue = (String) o;
                        rescueStationQueryWrapper.like(name, fileValue);
                    } else if ("city".equalsIgnoreCase(name) || "district".equalsIgnoreCase(name) || "affiliated_unit"
                            .equalsIgnoreCase(name)) {
                        String fileValue = (String) o;
                        rescueStationQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) o;
                        rescueStationQueryWrapper.like(name, fileValue);
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
        IPage<RescueStation> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iRescueStationService.page(pageBean, rescueStationQueryWrapper);
        IPage<RescueStationVo> rescueStationVoIPage = BeanDtoVoUtils.iPageVoStream(page, RescueStationVo.class);
        return ResponseHelper.buildResponse(rescueStationVoIPage);
    }
}

