package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 值班班次
 *
 * @author system_generator
 * @date 2021-07-06
 */
@Data
@ApiModel(value = "DutyPersonDto", description = "值班人")
public class DutyPersonExcelDto implements Serializable {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "序号", index = 0)
    @ApiModelProperty(value = "序号")
    private Integer number;

    @ExcelProperty(value = "用户id", index = 1)
    @ApiModelProperty(value = "用户id")
    private String userId;

    @ExcelProperty(value = "姓名", index = 2)
    @ApiModelProperty(value = "用户名称")
    private String userName;

    @ExcelIgnore
    @ApiModelProperty(value = "部门id")
    private String deptId;

    @ExcelIgnore
    @ApiModelProperty(value = "部门名称")
    private String deptName;

    @ApiModelProperty(value = "岗位id")
    private String postType;

    @ApiModelProperty(value = "岗位名称")
    private String postTypeName;

    @ApiModelProperty(value = "值班信息")
    private List<DutyPersonShiftDto> dutyShift;
}
