package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
* 报送对象
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_alert_submitted_object")
@ApiModel(value="AlertSubmittedObject对象", description="报送对象")
public class AlertSubmittedObject extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "报送单据id")
    private Long alertSubmittedId;

    @ApiModelProperty(value = "0人员1队伍")
    private Boolean type;

    @ApiModelProperty(value = " 单位id")
    private Long companyId;

    @ApiModelProperty(value = " 单位名称")
    private String companyName;

    @ApiModelProperty(value = "人员id")
    private Long userId;

    @ApiModelProperty(value = "人员名称")
    private String userName;

    @ApiModelProperty(value = "人员电话")
    private String userPhone;

    @ApiModelProperty(value = "操作人名称")
    @TableField(value = "rec_user_name",fill= FieldFill.INSERT_UPDATE )
    private String recUserName;

}
