package com.yeejoin.amos.boot.module.jcs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertSubmittedDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertSubmitted;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertSubmittedExtDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertSubmittedSMSDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* 警情报送记录 Mapper 接口
*
* @author tb
* @date 2021-06-17
*/
public interface AlertSubmittedMapper extends BaseMapper<AlertSubmitted> {
    /**
     * 根据参数获取融合调度列表
     *
     * @param alertSubmittedDto
     * @return
     */
    List<AlertSubmittedExtDto> listSchedulingByParam(@Param("alertSubmittedDto") AlertSubmittedDto alertSubmittedDto);

    /**
     * 根据参数获取警情报送列表
     *
     * @param alertSubmittedDto
     * @return
     */
    List<AlertSubmittedExtDto> listReportingByParam(@Param("alertSubmittedDto") AlertSubmittedDto alertSubmittedDto);

    /**
     * 获取融合调度短信内容
     * @param id id
     * @return 返回结果
     */
    AlertSubmittedSMSDto getSchedulingContent(@Param("id") Long id);


}
