package com.yeejoin.amos.boot.module.jcs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferCompanyDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferCompanyResourcesDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransfer;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 力量调派 Mapper 接口
 *
 * @author tb
 * @date 2021-06-17
 */
public interface PowerTransferMapper extends BaseMapper<PowerTransfer> {
    List<PowerTransferCompanyResourcesDto> getPowerTransferList(Long alertCalledId);

    List<PowerTransferCompanyDto> getLastPowerTransferCompany(Long alertCalledId);

    /**
     * 根据警情id获取调派车辆id列表
     *
     * @param alertCalledId
     * @return
     */
    List<String> queryTransferCarIdsByAlertCalledId(@Param("alertCalledId") Long alertCalledId);
}
