package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.FireStationDto;
import com.yeejoin.amos.boot.module.common.api.entity.FireStation;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.api.mapper.FireStationMapper;
import com.yeejoin.amos.boot.module.common.api.mapper.OrgUsrMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFireStationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Map;

/**
 * 微型消防站服务实现类
 *
 * @author system_generator
 * @date 2021-06-28
 */
@Service
public class FireStationServiceImpl extends BaseService<FireStationDto, FireStation, FireStationMapper>
        implements IFireStationService {

    @Autowired
    FireStationMapper fireStationMapper;
    @Autowired
    OrgUsrMapper orgUsrMapper;

    /**
     * 分页查询
     */
    public Page<FireStationDto> queryForFireStationPage(Page<FireStationDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<FireStationDto> queryForFireStationList(@Condition(Operator.eq) Boolean isDelete) {
        return this.queryForList("", false, isDelete);
    }

    /**
     * 删除
     */
    public Boolean updateisDelete(Long sequenceNbr) {

        return this.update(new UpdateWrapper<FireStation>().eq("sequence_nbr", sequenceNbr).set("is_delete", 1));
    }

    @Override
    public Page<FireStationDto> getFirefighters(int pageNum, int pageSize, FireStationDto par) {
        List<FireStationDto> list = fireStationMapper.getFireStation((pageNum - 1) * pageSize, pageSize, par);
        Map<String, Long> num = fireStationMapper.getFireStationCount(par);
        Page<FireStationDto> pageBean = new Page<>(pageNum, pageSize, num.get("num"));
        return pageBean.setRecords(list);
    }

    /**
     * 新增
     ***/
    public FireStationDto add(FireStationDto model) {

        if (model.getBizCompanyId() != null) {
            OrgUsr orgUsr = orgUsrMapper.selectById(model.getBizCompanyId());
            model.setBizCompany(orgUsr.getBizOrgName());
            model.setBizCompanyCode(orgUsr.getBizOrgCode());
        }
        FireStation entity = this.prepareEntity(model);
        this.save(entity);
        return Bean.toModel(entity, model);
    }

    /**
     * 修改
     ***/
    public FireStationDto Update(FireStationDto model) {
        if (model.getBizCompanyId() != null) {
            OrgUsr orgUsr = orgUsrMapper.selectById(model.getBizCompanyId());
            model.setBizCompany(orgUsr.getBizOrgName());
            model.setBizCompanyCode(orgUsr.getBizOrgCode());
        }
        FireStation entity = this.prepareEntity(model);
        this.updateById(entity);
        return Bean.toModel(entity, model);
    }
}
