package com.yeejoin.amos.boot.module.common.biz.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @title: DateUtils
 * @Author fpy
 * @Date: 2021/7/8 14:58
 * @Version 1.0
 */
public class DateUtils {

    private static final SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final Calendar calendar = Calendar.getInstance();
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    /**
     * 获取某月的日期List
     *
     * @param yearParam
     * @param monthParam
     * @return
     */
    public static List<String> getDayByMonth(int yearParam, int monthParam) {
        List list = new ArrayList();
        Calendar aCalendar = Calendar.getInstance(Locale.CHINA);
        aCalendar.set(yearParam, monthParam - 1, 1);
        int year = aCalendar.get(Calendar.YEAR);//年份
        int month = aCalendar.get(Calendar.MONTH) + 1;//月份
        int day = aCalendar.getActualMaximum(Calendar.DATE);
        for (int i = 1; i <= day; i++) {
            list.add(year + "/" + month + "/" + i);
        }
        return list;
    }

    /**
     * 获取某月的日期List
     *
     * @param dateStr
     * @return
     */
    public static List<Date> getDayByMonth(String dateStr) {
        List list = new ArrayList();
        Date date = null;
        try {
            date = shortSdf.parse(dateStr);
            calendar.setTime(date);
            int month = calendar.get(Calendar.MONTH) + 1;//月份
            int year = calendar.get(Calendar.YEAR);//年份
            int day = calendar.getActualMaximum(Calendar.DATE);
            for (int i = 1; i <= day; i++) {
                list.add(year + "/" + month + "/" + i);
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return list;
    }

    /**
     * 日期返回Date类型
     *
     * @param dateStr
     * @return
     */
    public static int strToDateShort(String dateStr) {
        try {
            Date date = shortSdf.parse(dateStr);
            calendar.setTime(date);
            int month = calendar.get(Calendar.MONTH) + 1;
            return month;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static Date getDate(String dateStr) {
        try {
            Date date = shortSdf.parse(dateStr);
            return date;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

}