package com.yeejoin.equip.config;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.equip.entity.EquipmentIndexVO;
import com.yeejoin.equip.mapper.mysql.EquipmentSpecificIndexMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import javax.annotation.Resource;
import java.util.List;

/**
 * @author LiuLin
 * @date 2023/6/15
 * @apiNote
 */
@Slf4j
@Component
@Transactional(transactionManager = "mysqlTransactionManager")
public class EquipmentIndexCacheRunner implements CommandLineRunner {
    @Resource
    private EquipmentSpecificIndexMapper equipmentSpecificIndexMapper;

    @Value("${spring.redis.host}")
    private String redisHost;

    @Value("${spring.redis.port}")
    private Integer redisPort;

    @Value("${spring.redis.password}")
    private String redisPassword;

    //@Autowired
    //private HandleESMessage2TDService handleESMessage2TDService;

    //@Autowired
    //private InitTDEngineDbService initTDEngineDbService;

    @Override
    public void run(String... args) throws Exception {
        Jedis jedis = new Jedis(redisHost, redisPort);
        jedis.auth(redisPassword);
        Pipeline pipeline = jedis.pipelined();
        List<EquipmentIndexVO> equipSpecificIndexList = equipmentSpecificIndexMapper.getEquipSpecificIndexList(null);
        equipSpecificIndexList.forEach(vo->{
            String key = vo.getIndexAddress() + "_" + vo.getGatewayId();
            pipeline.set(key, JSONObject.toJSONString(vo));
        });
        pipeline.syncAndReturnAll();
        log.info(">>>>>>>>>>>>>>>>服务启动执行Redis缓存预加载指标数据完成！>>>>>>>>>>>>>>>>");
        //initTDEngineDbService.init();
        //handleESMessage2TDService.syncEsData2TDEngine();
    }
}