package com.yeejoin.amos.api.householdapi.constant;

import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 固德威常量
 */

public class GoodWeConstant {
    public static final HashMap<String, String> stationStaus = new HashMap<String, String>() {
        {
            put("-1", "离线");
            put("0", "在线");
            put("1", "在线");
            put("2", "报警");
            put("-2", "报警");
        }
    };
    public static final HashMap<String, String> warningStaus = new HashMap<String, String>() {
        {
            put("0", "未处理");
            put("1", "已处理");
        }
    };
    public static final HashMap<String, String> taskStaus = new HashMap<String, String>() {
        {
            put("1", "已派送");
            put("2", "未派送");
        }
    };

    public static final HashMap<String, String> types = new HashMap<String, String>() {
        {
            put("0", "家庭户用");
            put("1", "工商业屋顶");
            put("2", "地面电站");
            put("3", "扶贫电站");
            put("4", "储能电站");

        }
    };











    public static final HashMap<String, List<String>> errorCodeMap = new HashMap<String, List<String>>() {
        {
            put("E0", Arrays.asList("漏电流自检异常",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.机器内部元器件出现故障",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E1", Arrays.asList("交流电流自检异常",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.机器内部元器件出现故障",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E2", Arrays.asList("采样基准电压异常",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.控制板有问题",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E3", Arrays.asList("直流分量校验异常",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.控制板有问题",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E4", Arrays.asList("漏电流校验异常",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.机器内部元器件出现故障",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E5", Arrays.asList("未知类型",
                    "1.请联系售后",
                    "1.请联系售后"));

            put("E6", Arrays.asList("漏电流传感器故障",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.控制板有问题",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E7", Arrays.asList("继电器故障",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.控制板有问题",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E8", Arrays.asList("交流传感器故障",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.控制板有问题",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E9", Arrays.asList("电网丢失故障",
                    "1.电网停电 |2.机器 AC 端接线异常|3.AC 开关连接异常或开关损坏|4.AC 端未连接",
                    "1.确定电网是否停电|2.利用万用表测量机器AC 端是否有电压|3.检查 AC 开关是否损坏|4.确认AC 端接线是否有误 （零火线是否接反）|5.确认电网连接正常，确保 AC 开关闭合|6.尝试g关闭机器DC/AC 端，5 分钟之后重新连接 DC/AC 端"));

            put("E10", Arrays.asList("漏电流高故障",
                    "1.交流测零地线接 线有误|2.报错发生在早晚或阴雨天气，空气湿度相对较高，也有可能引起报错",
                    "用万用变测量机器外壳对地是否有电压，若有电压说明 AC 端地线接线有问题"));

            put("E11", Arrays.asList("直流母线过高故障",
                    "1.光伏组串电压超过机器最大直流输入电压|2.机器控制板有问题",
                    "1.用万用表测量DC 端实际电压，看是否超过机器正常电压范围|2.如果 DC 电压超高，建议减少每个组串组件的数量，确保组串电压在机器最大直流输入电压范围内"));

            put("E12", Arrays.asList("内部风扇故障",
                    "1.外部风扇设备被异物阻塞|2.风扇内部接线有异常",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E13", Arrays.asList("机器温度过高故障",
                    "1.机器长时间在高温环境下运行|2.机器安装环境不利于机器散热（如比较封闭的环境等）",
                    "1. 设法降低机器周围的温度|2.检查机器安装是否满足产品用户手册要求|3. 尝试关闭机器，15 分钟后再重新打开"));

            put("E14", Arrays.asList("漏电流自检超时",
                    "机器自检时GFCI 值偏高导致",
                    "1.尝试重新启动机器，查看是否正常|2.可能需要升级机器软件版本解决问题"));

            put("E15", Arrays.asList("面板电压过高故障",
                    "PV 组串电压（开路电压）超出逆变器最大直流输入电压",
                    "1.用万用表测量DC 端实际电压，看是否超过机器正常电压范围|2.如果 DC 电压超高，建议减少每个组串组件的数量，确保组串电压在机器最大直流输入电压范围内"));

            put("E16", Arrays.asList("外部风扇故障",
                    "1.外部风扇设备被异物阻塞|2.风扇内部接线有异常",
                    "请检查风扇内部是否有异物阻塞"));

            put("E17", Arrays.asList("电网电压异常",
                    "1.安规设置错误|2.市电电压不稳定|3.交流线线径小，或者交流线较长导致交流线阻值较高，压降较高|4.交流线接线有误，导致交流端电压异常",
                    "1.检查机器安规设置是否正确，如不正确，请关闭交流电，更改安规后再连接交流电|2. 如果安规设置正确，请用万用表测量交流测每项火线对零线的电压值是否超出正常范围|3.确认机器安装地区市电电压是否有不稳定情况"));

            put("E18", Arrays.asList("面板绝缘阻抗低故障",
                    "1. 光伏面板接地线未连接或连接有误|2.直流线破损|3.交流端零、地线接线有误|4.报错发生在早晚或阴雨天气，空气湿度相对较高，易引发ISO 报错",
                    "1.依次插拔每串组件，确定引发报错的组串|2.检查直流线是否有破|3. 利用万用表测量AC 端零地线之间的电压是否过高（一般不超过 10V）， 如超过 10V， 则说明零地线接线异常|4.检查组件接地线是否有异常，确保每串组件接地线能够接触到大地"));

            put("E19", Arrays.asList("输出直流分量过高",
                    "机器检测到内部直流输入分量超出正常范围",
                    "请联系售后服务"));

            put("E20", Arrays.asList("LCD 通讯故障",
                    "1.内部LCD 数据线松动.",
                    "请联系售后服务"));

            put("E21", Arrays.asList("组串过流",
                    "某一组串电流过大",
                    "请检查组串连接情况"));

            put("E22", Arrays.asList("主从频率校验异常",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.控制板有问题",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E23", Arrays.asList("主从电压校验异常",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.控制板有问题",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E24", Arrays.asList("未知类型",
                    "请联系售后",
                    "请联系售后服务"));

            put("E25", Arrays.asList("继电器自检异常",
                    "1.三相机控制板和功率版之间的排线松动|2.交流端零、地线接线有误|3.机器控制板问题",
                    "1.利用万用表测量AC 端零地线之间的电压是否过高（一般不超过10V），如超过 10V， 则说明零地线接线异常|2. 尝试重启机器，看是否机器可回复正常工作"));

            put("E26", Arrays.asList("电池授权错误",
                    "连接该逆变器的电池功能未激活",
                    "请先购买电池激活码并在 PV Master 中激活电池功能，然后连接电池使用该功能"));

            put("E27", Arrays.asList("未知类型",
                    "1.请联系售后",
                    "1.请联系售后服务"));

            put("E28", Arrays.asList("未知类型",
                    "1.请联系售后",
                    "1.请联系售后服务"));

            put("E29", Arrays.asList("电网频率异常",
                    "1.安规设置错误|2.电网频率不稳定",
                    "1.检查机器安规设置是否正确，如不正确，请关闭交流电，更改安规后再连接交流电 |2.如果机器安规设置正确，请在机器页面查看是否电网频率（Fac）超出正常范围|3.如果“电网频率限”报错只是偶尔出现，并很快恢复正常，则说明报错是因为电网频率偶尔的不稳定造成的， 对系统正常运行不会影响"));

            put("E30", Arrays.asList("内部存储故障",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.机器内部元器件损",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));

            put("E31", Arrays.asList("内部通讯故障",
                    "1.受外部因素（如受 磁场影响等）引起的暂时性现象|2.控制板有问题",
                    "1.尝试重启机器，看机器是否仍然报错， 如果机器恢复正常，说明该报错只是偶然性事件，不会影响系统正常运行|2. 如果重启机器无法恢复正常，请联系售后服务"));
        }
    };


    public static String baseurl = "http://openapi.sems.com.cn";
    public static String account = "18679135705";

    public static String password = "Ljf5705@sems";
    public static String tokenurl = "/api/OpenApi/GetToken";
    public static String stationListUrl = "/api/OpenApi/GetUserPowerStation";
    public static String stationListStatusUrl = "/api/OpenApi/QueryPowerStationMonitor";
    public static String stationDetailUrl = "/api/OpenApi/GetPowerStationMonitorDetail";
    public static String stationGenUrl = "/api/OpenApi/GetPowerStationPower";
    public static String collectorListUrl = "/v1/api/collectorList";
    public static String collectorDetailUrl = "/v1/api/collectorDetail";
    public static String queryInventerUrl = "/api/OpenApi/QueryInventers";
    public static String getInventersDatas = "/api/OpenApi/GetInventersDatas";
    public static String getinverterGenURl = "/api/OpenApi/GetInverterPower";
    public static String inverterDetailUrl = "/v1/api/inverterDetail";
    public static String alarmListUrl = "/api/OpenApi/GetPowerStationWariningInfoByMultiCondition";
    public  static  String stationDayGenUrl ="/v1/api/stationDayEnergyList";
    public  static  String stationMonthEnergyList ="/v1/api/stationDayEnergyList";
    public  static  String stationYearEnergyList ="/v1/api/stationDayEnergyList";
    public  static  String inverterDayURL ="/v1/api/inverterDay";
    public  static  String inverterMonthURL ="/v1/api/inverterMonth";
    public  static  String inverterYearURL ="/v1/api/inverterYear";
    public  static  String snStatusURL ="/api/OpenApi/GetPowerStationMonitorDetailBySn";
    public static String resovleRule_data_page_records = "data,page,records";
    public static String resovleRule_data_list = "data,list";
    public static String resovleRule_data_records = "data,records";
    public static String resovleRule_data = "data";
    public static String requestPost = "POST";
    public static String requestGet = "GET";
    public static String datePattern = "yyyy-MM-dd HH:mm:ss.SSS";
    public static DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
    public static Double kwhToMwh = 0.0001;
    public static Double mwhTokwh = 1000.0;
    public static Double wToKw = 0.001;
}
