package com.yeejoin.amos.api.householdapi.controller;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.CompanyMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.io.File;
import java.io.IOException;
import java.util.List;

@RestController
@Api(tags = "测试")
@RequestMapping(value = "/station")
@Slf4j
public class StationImportController {
    @Autowired
    private CompanyMapper companyMapper;
    @Autowired
    private JpStationMapper jpStationMapper;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/importStation")
    @ApiOperation(httpMethod = "POST", value = "导入", notes = "导入")
    public void importStation(@RequestPart("file") MultipartFile file, @RequestParam("thirdCode") String thirdCode) throws IOException {
        log.info("=============开始执行==============");
        ExcelReader reader = ExcelUtil.getReader(file.getInputStream());
        List<List<Object>> read = reader.read(1);
        for (List<Object> objects : read) {
            String regionalCompanyName = (String) objects.get(0);
            String amosCompanyName = (String) objects.get(1);
            String stationName = (String) objects.get(2);
            String regionalCompanyNameCode = companyMapper.getCompanyNameCode(regionalCompanyName);
            if (StringUtils.isEmpty(regionalCompanyNameCode)&&StringUtils.isNotEmpty(regionalCompanyName)) {
                log.warn("====项目公司=====" + regionalCompanyName + "==========");
            }
            String amosCompanyNameCode = companyMapper.getCompanyNameCode(amosCompanyName);
            if (StringUtils.isEmpty(amosCompanyNameCode)&&StringUtils.isNotEmpty(amosCompanyName)) {
                log.warn("===经销商=====" + amosCompanyName + "==========");
            }
            updateJpStation(stationName, regionalCompanyNameCode, amosCompanyNameCode, thirdCode);
        }
        log.info("=============执行完成==============");
    }

    private void updateJpStation(String stationName, String regionalCompanyNameCode, String amosCompanyNameCode, String code) {
        UpdateWrapper<JpStation> wrapper = new UpdateWrapper<JpStation>()
                .set("regional_companies_code", regionalCompanyNameCode)
                .set("amos_company_code", amosCompanyNameCode)
                .eq("third_code", code)
                .eq("name", stationName);
        jpStationMapper.update(null, wrapper);
    }
}
