package com.yeejoin;

import com.yeejoin.amos.boot.biz.common.utils.oConvertUtils;
import com.yeejoin.equipmanage.listener.CarIotListener;
import com.yeejoin.equipmanage.listener.CarIotNewListener;
import com.yeejoin.equipmanage.thread.ThreadCarMileageTreatment;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

import java.net.InetAddress;
import java.net.UnknownHostException;

@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@EnableDiscoveryClient
@MapperScan({ "org.typroject.tyboot.demo.face.orm.dao*", "org.typroject.tyboot.face.*.orm.dao*",
	"org.typroject.tyboot.core.auth.face.orm.dao*", "org.typroject.tyboot.component.*.face.orm.dao*",
	"com.yeejoin.amos.boot.module.*.api.mapper", "com.yeejoin.amos.boot.biz.common.dao.mapper",
	"com.yeejoin.equipmanage.mapper"})
@ComponentScan(value = {"org.typroject", "com.yeejoin.amos", "com.yeejoin.equipmanage"}, excludeFilters = {
        @ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, classes = {org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler.class})})
@EnableFeignClients
@EnableAsync
public class AmostEquipApplication {

    private static final Logger logger = LoggerFactory.getLogger(AmostEquipApplication.class);

	@Autowired
	private EmqKeeper emqKeeper;

	@Autowired
	private CarIotListener carIotListener;

	@Autowired
	private CarIotNewListener carIotNewListener;

	@Autowired
	private ThreadCarMileageTreatment threadCarMileageTreatment;



    public static void main(String[] args) throws UnknownHostException {
    	ConfigurableApplicationContext context = SpringApplication.run(AmostEquipApplication.class, args);
		Environment env = context.getEnvironment();
		String ip = InetAddress.getLocalHost().getHostAddress();
		String port = env.getProperty("server.port");
		String path = oConvertUtils.getString(env.getProperty("server.servlet.context-path"));
		GlobalExceptionHandler.setAlwaysOk(true);
		logger.info("\n----------------------------------------------------------\n\t"
				+ "Application Amos-Biz-Boot is running! Access URLs:\n\t" + "Swagger文档: \thttp://" + ip + ":" + port
				+ path + "/doc.html\n" + "----------------------------------------------------------");
    }

	@Bean
	@LoadBalanced
	RestTemplate restTemplate(){
		return new RestTemplate();
	}

	/**
	 * 初始化MQTT
	 *
	 * @throws MqttException
	 */
	@Bean
	void initMqtt() throws MqttException {
		try {
			emqKeeper.subscript("+/+/property", 1, carIotListener);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("EMQ初始化连接失败!");
		}
	}

	//江西电建服务重启后对于未计时且未结束的里程的进行处理
	@Bean
	void initCarMelige() {
		threadCarMileageTreatment.start();
	}
}
