package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 商务信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CommercialDto", description="商务信息")
public class CommercialDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "商务类型",example = "zrr")
    private String type;

    @ApiModelProperty(value = "申请人",example = "admin")
    private String applicant;

    @ApiModelProperty(value = "身份证号",example = "610481199402245014")
    private String idCard;

    @ApiModelProperty(value = "申请人联系电话",example = "13022982292")
    private String telephone;

    @ApiModelProperty(value = "省市区",example = "[110000, 110100, 110101]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Integer> projectAddress;

    @ApiModelProperty(value = "省市区名称",example = "北京市/北京城区/东城区")
    private String projectAddressName;

   @ApiModelProperty(value = "省市区文字集合",example = "[\"北京市\", \"北京城区\", \"东城区\"]")
   private List<String> projectAddressText;

    @ApiModelProperty(value = "设备信息",example = "设备信息")
    private String device;

    @ApiModelProperty(value = "电子系统造价",example = "12.55")
    private Float cost;

    @ApiModelProperty(value = "安装规模",example = "23.52")
    private String scale;

    @ApiModelProperty(value = "法务类型",example = "zjdnhw")
    private String legalType;

    @ApiModelProperty(value = "有效联系电话",example = "13022982292")
    private String legalContactTelephone;

    @ApiModelProperty(value = "紧急联系人",example = "13022982292")
    private String legalEmergentTelephone;

    @ApiModelProperty(value = "结婚证文件标识",example = "[{\"url\": \"/upload/common/BABC7F938A4FF56B5CAFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> marriageCredit;

    @ApiModelProperty(value = "房产证文件标识",example = "[{\"url\": \"/upload/common/BABC7F938A125CAFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> realEstateCredit;

    @ApiModelProperty(value = "身份证正反面文件标识",example = "[{\"url\": \"/upload/common/BABC7F938A4213CAFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardCredit;

    @ApiModelProperty(value = "户口本文件标识",example = "[{\"url\": \"/upload/common/BABC7F938A4FF53213AFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> householdBookCredit;

    @ApiModelProperty(value = "手持身份证文件标识",example = "[{\"url\": \"/upload/common/BABC7F9321356B5CAFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> handIdCardCredit;

    @ApiModelProperty(value = "踏勘照片文件标识",example = "[{\"uid\": \"0.qcyinzogdcd\", \"url\": \"/upload/common/4CE66E78D6367C67CB4B71C03C7F30.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> surveyPhotosWeb;

    @ApiModelProperty(value = "组件平面图与组串连线图文件标识",example = "[{\"url\": \"/upload/common/B234234FF56B5CAFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> formationWeb;

    @ApiModelProperty(value = "房屋所有权继承说明文件标识",example = "[{\"url\": \"/upload/common/BABC7F938A4FF32423D9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> inheritWeb;

    @ApiModelProperty(value = "户用光伏电站项目合作协议文件标识",example = "[{\"url\": \"/upload/common/BAB423423AFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> agreementWeb;

    @ApiModelProperty(value = "用户手持身份证照片文件标识",example = "[{\"url\": \"/upload/common/BABC42342FD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> handIdCardLegal;

    @ApiModelProperty(value = "法人营业执照文件标识",example = "[{\"url\": \"/upload/common/BABC7F9382423AFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> licenseLegal;

    @ApiModelProperty(value = "法定代理人身份证文件标识",example = "[{\"url\": \"/upload/common/BABC7F938A4423423B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> agentLegal;

    @ApiModelProperty(value = "房产证明文件或乡镇街道土管部门房屋产权证明文件文件标识",example = "[{\"url\": \"/upload/common/BABC7F938Aads5CAFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> realEstateLegal;

    @ApiModelProperty(value = "房屋屋顶租赁协议/户用光伏共建开发协议文件标识",example = "[{\"url\": \"/upload/common/BABrwerF56B5CAFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> houseAgreementLegal;

    @ApiModelProperty(value = "法人的企业征信报告、工商内档文件标识",example = "[{\"url\": \"/upload/common/BABC7F938A4Fwqeqw9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> creditReportLegal;

    @ApiModelProperty(value = "项目备案证文件标识",example = "[{\"url\": \"/upload/common/BABdDsdadasdwrfAFSDSArf9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> filingsLegal;

    @ApiModelProperty(value = " 省市区详细地址",example = "北京市/北京城区/东城区")
    private String projectAddressDetail;

    @ApiModelProperty(value = "勘察表id",example = "1854346995112611841")
    private Long surveyInformationId;
}
