package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 投融整改单
 *
 * @author system_generator
 * @date 2024-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="FinancingRectificationOrderDto", description="投融整改单")
public class FinancingRectificationOrderDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "整改单号")
    private String rectificationOrderCode;

    @ApiModelProperty(value = "农户id")
    private Long peasantHouseholdId;


   @ApiModelProperty(value = "农户名称")
   private String peasantHouseholdName;
   @ApiModelProperty(value = "农户编号")
   private String peasantHouseholdNo;
   @ApiModelProperty(value = "地址")
   private String projectAddress;

    @ApiModelProperty(value = "问题描述")
    private String problemDescription;

    @ApiModelProperty(value = "整改状态")
    private String rectificationStatus;

    @ApiModelProperty(value = "整改描述")
    private String rectificationDescription;

    @ApiModelProperty(value = "完成日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private Date completeDate;

    @ApiModelProperty(value = "负责人ID")
    private Long responsibleUserId;

    @ApiModelProperty(value = "负责人姓名")
    private String responsibleUserName;

    @ApiModelProperty(value = "负责人电话")
    private String responsibleUserPhone;

    @ApiModelProperty(value = "整改照片")
    private String rectificationPhoto;

    @ApiModelProperty(value = "整改照片")
    private List<Object> rectificationPhotos;

}
