package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.dto.BasicGridRecordDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.WorkOrderPage;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfBusinessField;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface BusinessFieldMapper extends BaseMapper<HygfBusinessField> {
    /**
     * 获取电站的电站Id
     * @return
     */
    @UserEmpower(field = {"hph.regional_companies_code"}, dealerField = {"hph.regional_companies_code"}, fieldConditions = {"in"}, relationship = "and")
    List<String> getDzStationIdByProcessStatus(@Param("map") Map<String, Object> map);

    /**
     * 获取投融的电站Id
     * @return
     */
    @UserEmpower(field = {"sta.regional_companies_code"},dealerField = {"sta.developer_code","sta.regional_companies_code"},fieldConditions = {"eq","in"},relationship = {"and"})
    List<String> getTrStationIdByStatus(@Param(value = "params") Map<String,Object> params,@Param(value = "amosOrgCodes")List<String> amosOrgCodes);

    /**
     * 获取施工验收场站Id
     * @param map
     * @return
     */
    @UserEmpower(field = {"region_code"}, dealerField = {"hygf_work_order.amos_dealer_org_code","hygf_work_order.region_code","hygf_peasant_household.developer_user_id"}, fieldConditions = {"in", "in", "in"}, relationship = "and")
    List<String> getSgysStationId(@Param("dto") Map<String, Object> map);

    /**
     * 获取并网验收场站Id
     * @param map
     * @return
     */
    @UserEmpower(field ={"hph.regional_companies_code"} ,dealerField={"hph.developer_code","hph.regional_companies_code","hph.developer_user_id"},fieldConditions ={"in","in","in"} ,relationship="and")
    List<String> getBwysStationId(@Param("map") Map<String, Object> map);

    /**
     * 获取验收审核场站Id
     * @param map
     * @return
     */
    @UserEmpower(field ={"hph.regional_companies_code"} ,dealerField={"hph.developer_code","hph.regional_companies_code","hph.developer_user_id"},fieldConditions ={"in","in","in"} ,relationship="and")
    List<String> getYsshStationId(@Param("map") Map<String, Object> map);

    /**
     * 获取发货场站
     * @param map
     * @return
     */
    @UserEmpower(field ={"regional_companies_code"} ,dealerField={"developer_code","regional_companies_code"} ,fieldConditions ={"eq","in"} ,relationship="and")
    List<String> getFhStationId (@Param("map") Map<String, Object> map);
    /**
     * 获取基本信息
     * @param stationIdList
     * @return
     */
    List<Map<String, Object>> getBasicInformation(@Param("list") List<String> stationIdList);

    /**
     * 获取勘察信息
     * @param stationIdList
     * @return
     */
    List<Map<String, Object>> getSurveyInformation(@Param("list") List<String> stationIdList);

    /**
     * 获取设计信息
     * @param stationIdList
     * @return
     */
    List<Map<String, Object>> getDesignInformation(@Param("list") List<String> stationIdList);

    /**
     * 获取商务信息
     * @param stationIdList
     * @return
     */
    List<Map<String, Object>> getBusinessInformation(@Param("list") List<String> stationIdList);

    /**
     * 获取扩展信息
     * @param stationIdList
     * @return
     */
    List<Map<String, Object>> getExtendedInformation(@Param("list") List<String> stationIdList);

    /**
     * 获取资料归档信息
     * @param stationIdList
     * @return
     */
    List<Map<String, Object>> getArchivingInformation(@Param("list") List<String> stationIdList);

    /**
     * 获取工程信息
     * @param stationIdList
     * @return
     */
    List<Map<String, Object>> getEngineeringInformation(@Param("list") List<String> stationIdList);

    /**
     * 获取并网信息
     * @param stationIdList
     * @return
     */
    List<Map<String, Object>> getGridInformation(@Param("list") List<String> stationIdList);

    /**
     * 获取派工单信息
     * @param stationIdList
     * @return
     */
    List<Map<String, Object>> getDispatchOrderInformation(@Param("list") List<String> stationIdList);

}
