package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.BasicGridRecordDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.AcceptanceCheck;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfRectificationOrder;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.AcceptanceCheckServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceCheckDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 并网验收节点
 *
 * @author system_generator
 * @date 2024-08-21
 */
@RestController
@Api(tags = "并网验收节点Api")
@RequestMapping(value = "/acceptance-check")
public class AcceptanceCheckController extends BaseController {

    @Autowired
    AcceptanceCheckServiceImpl acceptanceCheckServiceImpl;


	@Value("${admin.tourong.roleId}")
	Long tourongId;
	@Value("${admin.fawu.roleId}")
	Long fawuId;
	@Value("${admin.area.roleId}")
	Long areaId;
	@Value("${admin.zichan.roleId}")
	Long zichanId;
	@Value("${admin.delerKaId.roleId}")
	Long kaifaId;
	@Value("${admin.delerAdmin.roleId}")
	Long delerAdminId;

    /**
     * 新增并网验收节点
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save/commit")
	@ApiOperation(httpMethod = "POST", value = "新增并网验收节点", notes = "新增并网验收节点")
	public ResponseModel<AcceptanceCheck> save(@RequestBody Map<String,Object> model) {

		String realName = getSelectedOrgInfo().getUserModel().getRealName();
		model.put("realName",realName);
		return ResponseHelper.buildResponse(acceptanceCheckServiceImpl.saveAndCommit(model));
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新并网验收节点", notes = "根据sequenceNbr更新并网验收节点")
	public ResponseModel<AcceptanceCheckDto> updateBySequenceNbrAcceptanceCheck(@RequestBody AcceptanceCheckDto model,@ApiParam(value = "主键",example = "1805040753609568257")@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(acceptanceCheckServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除并网验收节点", notes = "根据sequenceNbr删除并网验收节点")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @ApiParam(value = "主键",example = "1805040753609568257")@PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(acceptanceCheckServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个并网验收节点",  notes = "根据sequenceNbr查询单个并网验收节点")
	public ResponseModel<AcceptanceCheckDto> selectOne(@ApiParam(value = "主键",example = "1805040753609568257")@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(acceptanceCheckServiceImpl.queryBySeq(sequenceNbr));
	}


	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "并网验收节点列表全部数据查询",   notes = "并网验收节点列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<AcceptanceCheckDto>> selectForList() {
	    return ResponseHelper.buildResponse(acceptanceCheckServiceImpl.queryForAcceptanceCheckList());
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "验收-经销商管理",   notes = "验收经销商管理")
	@PostMapping(value = "/completeAdminAudit")
	@Transactional
	public ResponseModel completeAdminAudit( @RequestBody Map<String,String> kv) {
		acceptanceCheckServiceImpl.completeAdminAudit(kv);
		return ResponseHelper.buildResponse(null);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "验收管理审核",   notes = "验收管理审核")
	@PostMapping(value = "/completeAudit")
	@Transactional
	public ResponseModel completeAudit( @RequestBody Map<String,String> kv) {
		return	acceptanceCheckServiceImpl.completeAudit(kv);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "整改单下发",   notes = "整改单下发")
	@PostMapping(value = "/addRectification")
	@Transactional
	public ResponseModel addRectification( @RequestBody HygfRectificationOrder hygfReplenishment) {



		return	acceptanceCheckServiceImpl.addRectification(hygfReplenishment);

	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "整改单添加信息",   notes = "整改单添加信息")
	@PostMapping(value = "/nextTaskExcute")
	@Transactional
	public ResponseModel nextTaskExcute( @RequestBody HygfRectificationOrder hygfReplenishment) {


		return acceptanceCheckServiceImpl.nextTaskExcute(hygfReplenishment);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "整改单审核",   notes = "整改单审核")
	@PostMapping(value = "/nextTaskAduit")
	@Transactional
	public ResponseModel nextTaskAduit( @RequestBody HygfRectificationOrder hygfReplenishment) {


		return	acceptanceCheckServiceImpl.nextTaskAduit(hygfReplenishment);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "PUT",value = "整改单作废",   notes = "整改单作废")
	@PutMapping(value = "/rollback")
	@Transactional
	public ResponseModel rollback(@ApiParam(value = "主键",example = "1805040753609568257") @RequestParam(value = "sequenceNbr") Long sequenceNbr) {


		return acceptanceCheckServiceImpl.rollback(sequenceNbr);
	}




	/**
	 * 经销商端列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	@UserLimits
	public ResponseModel<Page<AcceptanceCheckDto>> queryForPage(@ApiParam(value = "当前页码",example = "1")@RequestParam(value = "current") int current,
																@ApiParam(value = "分数条数",example = "20")@RequestParam(value = "size") int size,
																@ApiParam(value = "项目区域",example = "xx市")@RequestParam(required = false,value = "projectAddress") String projectAddress,
																@ApiParam(value = "电站编号",example = "NH057NMGZZHHHTHM202405159165")@RequestParam(required = false,value = "powerStationCode") String powerStationCode,
																@ApiParam(value = "业主姓名",example = "曹文轩")@RequestParam(required = false,value = "ownersName") String ownersName,
																@ApiParam(value = "验收状态",example = "1")@RequestParam(required = false,value = "acceptanceCheckStatus") String acceptanceCheckStatus,
																@ApiParam(value = "区分经销商端或管理端 为空则为经销商端",example = "1805040753609568257")@RequestParam(required = false,value = "type") String type,
																@ApiParam(value = "验收时间",example = "2024-03-05 00:00:00")@RequestParam(required = false,value = "acceptanceTime") String acceptanceTime,
																@ApiParam(value = "省份",example = "xx省")@RequestParam(required = false, value = "province") String province,
																@ApiParam(value = "经销商公司名称",example = "xxxxx公司")@RequestParam(required = false, value = "developerName") String developerName,
																@ApiParam(value = "区域公司名称",example = "xxxxx公司")@RequestParam(required = false, value = "regionalCompaniesName") String regionalCompaniesName,
																@ApiParam(value = "筛选用第一次提交开始时间",example = "2024-03-05 00:00:00")@RequestParam(required = false, value = "startTime") String startTime,
																@ApiParam(value = "筛选用第一次提交结束时间",example = "2024-05-05 23:00:59")@RequestParam(required = false, value = "endTime") String endTime,
																@RequestParam(required = false, value = "routhPathId") String routhPathId) throws Exception {
		//当前登录人所属场站
//        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto( getUserInfo().getUserId());

		ReginParams reginParams = getSelectedOrgInfo();
		List<String> basicGridNodes = new ArrayList<>();
		List<Long> roleIds = new ArrayList<>();
		for (Long aLong : reginParams.getUserModel().getOrgRoleSeqs().keySet()) {
			List<Long> longs = reginParams.getUserModel().getOrgRoleSeqs().get(aLong);
			roleIds.addAll(longs);
			if (longs.contains(areaId)) {
				basicGridNodes.add("ys-area");
			}
			if (longs.contains(tourongId)) {
				basicGridNodes.add("ys-tourong");
			}
			if (longs.contains(fawuId)) {
				basicGridNodes.add("ys-fawu");
			}
			if (longs.contains(zichanId)) {
				basicGridNodes.add("ys-zichan");
			}
			if (longs.contains(delerAdminId)) {
				basicGridNodes.add("ys-tourong");
				basicGridNodes.add("ys-area");
				basicGridNodes.add("ys-fawu");
				basicGridNodes.add("ys-zichan");
			}
		}
		Page<AcceptanceCheckDto> page = acceptanceCheckServiceImpl.selectPage(null,null,current, size, projectAddress, powerStationCode, ownersName, acceptanceCheckStatus, acceptanceTime, "",basicGridNodes,type,province, developerName, regionalCompaniesName, startTime, endTime,routhPathId);
		//根据角色及当前节点判断是否有操作权限
		if (basicGridNodes != null){
			for (AcceptanceCheckDto e : page.getRecords()) {
				for (String g : basicGridNodes) {
					if (null != e.getBasicGridNode() && e.getBasicGridNode().contains(g) && (roleIds.contains(areaId) ||roleIds.contains(fawuId) ||  roleIds.contains(zichanId)||  roleIds.contains(tourongId))){
						e.setIsAudit("0");
						break;
					}if (null != e.getBasicGridNode()&&e.getBasicGridNode().equals("jxsAdmin") && roleIds.contains(delerAdminId)){
						e.setIsAudit("0");
						break;
					}
					else {
						e.setIsAudit("1");
					}
				}
			}
		}
		return ResponseHelper.buildResponse(page);
	}

}
