package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.MaintenanceLogServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.MaintenanceLogDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 运维人员操作记录
 *
 * @author system_generator
 * @date 2024-03-11
 */
@RestController
@Api(tags = "运维人员操作记录Api")
@RequestMapping(value = "/maintenance-log")
public class MaintenanceLogController extends BaseController {

    @Autowired
    MaintenanceLogServiceImpl maintenanceLogServiceImpl;

    /**
     * 新增运维人员操作记录
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增运维人员操作记录", notes = "新增运维人员操作记录")
	public ResponseModel<MaintenanceLogDto> save(@RequestBody MaintenanceLogDto model) {
	    model = maintenanceLogServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新运维人员操作记录", notes = "根据sequenceNbr更新运维人员操作记录")
	public ResponseModel<MaintenanceLogDto> updateBySequenceNbrMaintenanceLog(@RequestBody MaintenanceLogDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(maintenanceLogServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除运维人员操作记录", notes = "根据sequenceNbr删除运维人员操作记录")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(maintenanceLogServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个运维人员操作记录",  notes = "根据sequenceNbr查询单个运维人员操作记录")
	public ResponseModel<MaintenanceLogDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(maintenanceLogServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "运维人员操作记录分页查询",  notes = "运维人员操作记录分页查询")
	public ResponseModel<Page<MaintenanceLogDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<MaintenanceLogDto> page = new Page<MaintenanceLogDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(maintenanceLogServiceImpl.queryForMaintenanceLogPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "运维人员操作记录列表全部数据查询",   notes = "运维人员操作记录列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<MaintenanceLogDto>> selectForList() {
	    return ResponseHelper.buildResponse(maintenanceLogServiceImpl.queryForMaintenanceLogList());
	}
}
