package com.yeejoin.amos.boot.module.hygf.biz.excel.impl;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.hygf.api.entity.StdUserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.mapper.BusinessFieldMapper;
import com.yeejoin.amos.boot.module.hygf.biz.excel.service.IExportPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.*;

@Service
public class RzwtgServiceImpl implements IExportPageService {
    @Autowired
    private BusinessFieldMapper businessFieldMapper;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public List<String> getStationId(Map<String, Object> filters) {
        StdUserEmpower orgCode = (StdUserEmpower) redisUtils.get("Emp_" + RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken()));
        List<String> amosOrgCodes = orgCode.getAmosOrgCode();
        Map<String, Object> params = new HashMap<>();
        if (Objects.nonNull(filters)) {
            params.putAll(filters);
        }
        String status="审核不通过,重新验收";
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        Long sequenceNbr = reginParams.getCompany().getSequenceNbr();
        params.put("financingCompaniesSeq", String.valueOf(sequenceNbr));
        params.put("status", Objects.isNull(filters.get("status")) ? Arrays.asList(status.split(",")) : Arrays.asList(filters.get("status")));
        params.put("type", "2");
        return businessFieldMapper.getTrStationIdByStatus(params,amosOrgCodes);
    }
}
