package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DynamicFormInstanceDto;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 动态表单实例表 Mapper 接口
 *
 * @author system_generator
 * @date 2021-07-06
 */
public interface DynamicFormInstanceMapper extends BaseMapper<DynamicFormInstance> {

    public List<DynamicFormInstanceDto> selectListByCalledId(Long id);

    /**
     * 列转行查询
     *
     * @param appKey     应用标识
     * @param fieldCodes 列
     * @param groupCode  分组code
     * @param params     查询参数map
     * @return List<Map>
     */
    List<Map<String, Object>> listAll(
            @Param("appKey") String appKey,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("groupCode") String groupCode,
            @Param("params") Map<String, String> params
    );

    /**
     * 分页查询
     *
     * @param page       分页信息
     * @param appKey     应用
     * @param fieldCodes 字段
     * @param groupCode  表单类型
     * @return IPage<Map < String, Object>>
     */
    IPage<Map<String, Object>> pageList(
            Page page,
            @Param("appKey") String appKey,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("groupCode") String groupCode,
            @Param("params") Map<String, String> params
    );

    /**
     * 查询指定日期的值班信息
     * @param dutyDay    值班日期
     * @param shiftId    班次id
     * @param fieldCodes 动态列
     * @param appKey     应用标识
     * @param groupCode 表单类型
     * @param params 查询条件
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> listOneDayDutyPerson(
            @Param("dutyDate") String dutyDay,
            @Param("shiftId") Long shiftId,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("appKey") String appKey,
            @Param("groupCode") String groupCode,
            @Param("params") Map<String, String> params);

    /**
     * 查询当前值班信息
     * @param dutyDay    值班日期
     * @param shiftIds    班次id
     * @param fieldCodes 动态列
     * @param groupCode 表单类型
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> listOnDutyPerson(
            @Param("dutyDate") String dutyDay,
            @Param("shiftId") String shiftIds,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("groupCode") String groupCode);
}
